/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.Collation;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.PropertyExpression;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.JSONUtils;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Expression {
    private static final String PARAM_EXPRESSION = "expression";

    @NonNull
    public static Expression value(@Nullable Object value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression string(@Nullable String value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression number(@Nullable Number value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression intValue(int value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression longValue(long value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression floatValue(float value) {
        return new ValueExpression(Float.valueOf(value));
    }

    @NonNull
    public static Expression doubleValue(double value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression booleanValue(boolean value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression date(@Nullable Date value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression map(@Nullable Map<String, Object> value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression list(@Nullable List<Object> value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static PropertyExpression all() {
        return new PropertyExpression("");
    }

    @NonNull
    public static PropertyExpression property(@NonNull String property) {
        Preconditions.assertNotNull(property, "property");
        return new PropertyExpression(property);
    }

    @NonNull
    public static Expression parameter(@NonNull String name) {
        Preconditions.assertNotNull(name, "name");
        return new ParameterExpression(name);
    }

    @NonNull
    public static Expression negated(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new CompoundExpression(Arrays.asList(expression), CompoundExpression.OpType.Not);
    }

    @NonNull
    public static Expression not(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return Expression.negated(expression);
    }

    @Nullable
    abstract Object asJSON();

    @NonNull
    public Expression multiply(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, BinaryExpression.OpType.Multiply);
    }

    @NonNull
    public Expression divide(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, BinaryExpression.OpType.Divide);
    }

    @NonNull
    public Expression modulo(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, BinaryExpression.OpType.Modulus);
    }

    @NonNull
    public Expression add(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, BinaryExpression.OpType.Add);
    }

    @NonNull
    public Expression subtract(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, BinaryExpression.OpType.Subtract);
    }

    @NonNull
    public Expression lessThan(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, BinaryExpression.OpType.LessThan);
    }

    @NonNull
    public Expression lessThanOrEqualTo(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, BinaryExpression.OpType.LessThanOrEqualTo);
    }

    @NonNull
    public Expression greaterThan(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, BinaryExpression.OpType.GreaterThan);
    }

    @NonNull
    public Expression greaterThanOrEqualTo(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, BinaryExpression.OpType.GreaterThanOrEqualTo);
    }

    @NonNull
    public Expression equalTo(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, BinaryExpression.OpType.EqualTo);
    }

    @NonNull
    public Expression notEqualTo(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, BinaryExpression.OpType.NotEqualTo);
    }

    @NonNull
    public Expression and(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new CompoundExpression(Arrays.asList(this, expression), CompoundExpression.OpType.And);
    }

    @NonNull
    public Expression or(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new CompoundExpression(Arrays.asList(this, expression), CompoundExpression.OpType.Or);
    }

    @NonNull
    public Expression like(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, BinaryExpression.OpType.Like);
    }

    @NonNull
    public Expression regex(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, BinaryExpression.OpType.RegexLike);
    }

    @NonNull
    public Expression is(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, BinaryExpression.OpType.Is);
    }

    @NonNull
    public Expression isNot(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, BinaryExpression.OpType.IsNot);
    }

    @NonNull
    public Expression between(@NonNull Expression expression1, @NonNull Expression expression2) {
        Preconditions.assertNotNull(expression1, "lower bound");
        Preconditions.assertNotNull(expression2, "upper bound");
        AggregateExpression aggr = new AggregateExpression(Arrays.asList(expression1, expression2));
        return new BinaryExpression(this, aggr, BinaryExpression.OpType.Between);
    }

    @Deprecated
    @NonNull
    public Expression isNullOrMissing() {
        return new UnaryExpression(this, UnaryExpression.OpType.Null).or(new UnaryExpression(this, UnaryExpression.OpType.Missing));
    }

    @Deprecated
    @NonNull
    public Expression notNullOrMissing() {
        return Expression.negated(this.isNullOrMissing());
    }

    @NonNull
    public Expression isValued() {
        return new UnaryExpression(this, UnaryExpression.OpType.Valued);
    }

    @NonNull
    public Expression isNotValued() {
        return Expression.negated(this.isValued());
    }

    @NonNull
    public Expression collate(@NonNull Collation collation) {
        Preconditions.assertNotNull(collation, "collation");
        return new CollationExpression(this, collation);
    }

    @NonNull
    public Expression in(Expression ... expressions) {
        if (expressions.length <= 0) {
            throw new IllegalArgumentException("empty 'IN'.");
        }
        AggregateExpression aggr = new AggregateExpression(Arrays.asList(expressions));
        return new BinaryExpression(this, aggr, BinaryExpression.OpType.In);
    }

    @NonNull
    public String toString() {
        return this.getClass().getSimpleName() + "{" + ClassUtils.objId(this) + ",json=" + this.asJSON() + "}";
    }

    static final class FunctionExpression
    extends Expression {
        @NonNull
        private final String func;
        @NonNull
        private final List<Expression> params;

        FunctionExpression(@NonNull String func, @NonNull List<Expression> params) {
            this.func = func;
            this.params = params;
        }

        @Override
        @NonNull
        Object asJSON() {
            ArrayList<Object> json = new ArrayList<Object>();
            json.add(this.func);
            for (Expression expr : this.params) {
                json.add(expr.asJSON());
            }
            return json;
        }
    }

    static final class CollationExpression
    extends Expression {
        @NonNull
        private final Expression operand;
        @NonNull
        private final Collation collation;

        CollationExpression(@NonNull Expression operand, @NonNull Collation collation) {
            this.operand = operand;
            this.collation = collation;
        }

        @Override
        @NonNull
        Object asJSON() {
            ArrayList<Object> json = new ArrayList<Object>(3);
            json.add("COLLATE");
            json.add(this.collation.asJSON());
            json.add(this.operand.asJSON());
            return json;
        }
    }

    static final class ParameterExpression
    extends Expression {
        @NonNull
        private final String name;

        ParameterExpression(@NonNull String name) {
            this.name = name;
        }

        @Override
        @NonNull
        Object asJSON() {
            ArrayList<String> json = new ArrayList<String>();
            json.add("$" + this.name);
            return json;
        }
    }

    static final class UnaryExpression
    extends Expression {
        @NonNull
        private final Expression operand;
        @NonNull
        private final OpType type;

        UnaryExpression(@NonNull Expression operand, @NonNull OpType type) {
            Preconditions.assertNotNull(operand, "operand");
            this.operand = operand;
            this.type = type;
        }

        @Override
        @NonNull
        Object asJSON() {
            Object opd = this.operand.asJSON();
            switch (this.type) {
                case Missing: {
                    ArrayList<String> values = new ArrayList<String>();
                    values.add("MISSING");
                    return Arrays.asList("IS", opd, values);
                }
                case NotMissing: {
                    ArrayList<String> values = new ArrayList<String>();
                    values.add("MISSING");
                    return Arrays.asList("IS NOT", opd, values);
                }
                case Null: {
                    return Arrays.asList("IS", opd, null);
                }
                case NotNull: {
                    return Arrays.asList("IS NOT", opd, null);
                }
                case Valued: {
                    return Arrays.asList("IS VALUED", opd);
                }
            }
            Log.i(LogDomain.QUERY, "Unexpected unary type: " + (Object)((Object)this.type));
            return Arrays.asList(new Object[0]);
        }

        private static enum OpType {
            Missing,
            NotMissing,
            NotNull,
            Null,
            Valued;

        }
    }

    static final class CompoundExpression
    extends Expression {
        @NonNull
        private final OpType type;
        @NonNull
        private final List<Expression> subexpressions;

        CompoundExpression(@NonNull List<Expression> subexpressions, @NonNull OpType type) {
            Preconditions.assertNotNull(subexpressions, "subexpressions");
            this.type = type;
            this.subexpressions = subexpressions;
        }

        @Override
        @NonNull
        Object asJSON() {
            ArrayList<Object> json = new ArrayList<Object>();
            switch (this.type) {
                case And: {
                    json.add("AND");
                    break;
                }
                case Or: {
                    json.add("OR");
                    break;
                }
                case Not: {
                    json.add("NOT");
                }
            }
            for (Expression expr : this.subexpressions) {
                json.add(expr.asJSON());
            }
            return json;
        }

        private static enum OpType {
            And,
            Or,
            Not;

        }
    }

    static final class BinaryExpression
    extends Expression {
        @NonNull
        private final Expression lhs;
        @NonNull
        private final Expression rhs;
        @NonNull
        private final OpType type;

        BinaryExpression(@NonNull Expression lhs, @NonNull Expression rhs, @NonNull OpType type) {
            this.lhs = lhs;
            this.rhs = rhs;
            this.type = type;
        }

        @Override
        @NonNull
        Object asJSON() {
            ArrayList<Object> json = new ArrayList<Object>();
            switch (this.type) {
                case Add: {
                    json.add("+");
                    break;
                }
                case Between: {
                    json.add("BETWEEN");
                    break;
                }
                case Divide: {
                    json.add("/");
                    break;
                }
                case EqualTo: {
                    json.add("=");
                    break;
                }
                case GreaterThan: {
                    json.add(">");
                    break;
                }
                case GreaterThanOrEqualTo: {
                    json.add(">=");
                    break;
                }
                case In: {
                    json.add("IN");
                    break;
                }
                case Is: {
                    json.add("IS");
                    break;
                }
                case IsNot: {
                    json.add("IS NOT");
                    break;
                }
                case LessThan: {
                    json.add("<");
                    break;
                }
                case LessThanOrEqualTo: {
                    json.add("<=");
                    break;
                }
                case Like: {
                    json.add("LIKE");
                    break;
                }
                case Modulus: {
                    json.add("%");
                    break;
                }
                case Multiply: {
                    json.add("*");
                    break;
                }
                case NotEqualTo: {
                    json.add("!=");
                    break;
                }
                case RegexLike: {
                    json.add("regexp_like()");
                    break;
                }
                case Subtract: {
                    json.add("-");
                }
            }
            json.add(this.lhs.asJSON());
            if (this.type != OpType.Between) {
                json.add(this.rhs.asJSON());
            } else {
                List<Expression> rangeExprs = ((AggregateExpression)this.rhs).getExpressions();
                json.add(rangeExprs.get(0).asJSON());
                json.add(rangeExprs.get(1).asJSON());
            }
            return json;
        }

        private static enum OpType {
            Add,
            Between,
            Divide,
            EqualTo,
            GreaterThan,
            GreaterThanOrEqualTo,
            In,
            Is,
            IsNot,
            LessThan,
            LessThanOrEqualTo,
            Like,
            Modulus,
            Multiply,
            NotEqualTo,
            Subtract,
            RegexLike;

        }
    }

    static final class AggregateExpression
    extends Expression {
        @NonNull
        private final List<Expression> expressions;

        AggregateExpression(@NonNull List<Expression> expressions) {
            this.expressions = expressions;
        }

        @NonNull
        public List<Expression> getExpressions() {
            return this.expressions;
        }

        @Override
        @NonNull
        Object asJSON() {
            ArrayList<Object> json = new ArrayList<Object>();
            json.add("[]");
            for (Expression expr : this.expressions) {
                json.add(expr.asJSON());
            }
            return json;
        }
    }

    static final class ValueExpression
    extends Expression {
        @Nullable
        private final Object value;

        ValueExpression(@Nullable Object value) {
            this.verifySupportedType(value);
            this.value = value;
        }

        @Override
        @Nullable
        Object asJSON() {
            return this.asJSON(this.value);
        }

        @Nullable
        private Object asJSON(@Nullable Object value) {
            if (value instanceof Date) {
                return JSONUtils.toJSONString((Date)value);
            }
            if (value instanceof Map) {
                return this.mapAsJSON((Map)value);
            }
            if (value instanceof List) {
                return this.listAsJSON((List)value);
            }
            if (value instanceof Expression) {
                return ((Expression)value).asJSON();
            }
            this.verifySupportedType(value);
            return value;
        }

        @NonNull
        private Object mapAsJSON(@NonNull Map<String, Object> map) {
            HashMap<String, Object> json = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                json.put(entry.getKey(), this.asJSON(entry.getValue()));
            }
            return json;
        }

        @NonNull
        private Object listAsJSON(@NonNull List<Object> list) {
            ArrayList<Object> json = new ArrayList<Object>();
            json.add("[]");
            for (Object obj : list) {
                json.add(this.asJSON(obj));
            }
            return json;
        }

        private void verifySupportedType(@Nullable Object value) {
            if (value == null || value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Date || value instanceof Map || value instanceof List || value instanceof Expression) {
                return;
            }
            throw new IllegalArgumentException("Unsupported expression value type: " + value.getClass());
        }
    }
}

