/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogFileConfiguration;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.Logger;
import com.couchbase.lite.internal.core.C4Log;
import com.couchbase.lite.internal.core.CBLVersion;
import com.couchbase.lite.internal.support.Log;
import java.io.File;

public final class FileLogger
implements Logger {
    @Nullable
    private volatile LogFileConfiguration config;
    @Nullable
    private volatile String initializedPath;
    @NonNull
    private volatile LogLevel logLevel = LogLevel.NONE;

    FileLogger() {
        this.reset();
    }

    @Override
    public void log(@NonNull LogLevel level, @NonNull LogDomain domain, @NonNull String message) {
        if (this.config == null || level.compareTo(this.logLevel) < 0) {
            return;
        }
        C4Log.log(Log.getC4DomainForLoggingDomain(domain), Log.getC4LevelForLogLevel(level), message);
    }

    @Override
    @NonNull
    public LogLevel getLevel() {
        return this.logLevel;
    }

    public void setLevel(@NonNull LogLevel level) {
        if (this.config == null) {
            throw new IllegalStateException(Log.lookupStandardMessage("CannotSetLogLevel"));
        }
        if (this.logLevel == level) {
            return;
        }
        this.logLevel = level;
        if (!this.initLog()) {
            C4Log.setBinaryFileLevel(Log.getC4LevelForLogLevel(level));
        }
        if (level == LogLevel.NONE) {
            Log.warn();
        }
    }

    @Nullable
    public LogFileConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(@Nullable LogFileConfiguration newConfig) {
        if (this.config == newConfig) {
            return;
        }
        if (newConfig == null) {
            this.config = null;
            Log.warn();
            return;
        }
        File logDir = new File(newConfig.getDirectory());
        String errMsg = null;
        if (!logDir.exists()) {
            if (!logDir.mkdirs()) {
                errMsg = "Cannot create log directory: " + logDir.getAbsolutePath();
            }
        } else if (!logDir.isDirectory()) {
            errMsg = logDir.getAbsolutePath() + " is not a directory";
        } else if (!logDir.canWrite()) {
            errMsg = logDir.getAbsolutePath() + " is not writable";
        }
        if (errMsg != null) {
            Log.w(LogDomain.DATABASE, errMsg);
            return;
        }
        this.config = new LogFileConfiguration(newConfig.getDirectory(), newConfig, true);
        this.initLog();
    }

    @VisibleForTesting
    void reset() {
        this.config = null;
        this.initializedPath = null;
        this.logLevel = LogLevel.NONE;
    }

    private boolean initLog() {
        LogLevel level = this.logLevel;
        LogFileConfiguration cfg = this.config;
        if (cfg == null || level == LogLevel.NONE) {
            return false;
        }
        String logDirPath = cfg.getDirectory();
        if (logDirPath.equals(this.initializedPath)) {
            return false;
        }
        this.initializedPath = logDirPath;
        C4Log.writeToBinaryFile(logDirPath, Log.getC4LevelForLogLevel(level), cfg.getMaxRotateCount(), cfg.getMaxSize(), cfg.usesPlaintext(), CBLVersion.getVersionInfo());
        return true;
    }
}

