/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.AbstractIndex;
import com.couchbase.lite.FullTextIndexItem;
import com.couchbase.lite.Index;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class FullTextIndex
extends Index {
    @NonNull
    private final List<FullTextIndexItem> indexItems;
    @NonNull
    private String language = Locale.getDefault().getLanguage();
    private boolean ignoreDiacritics;

    FullTextIndex(FullTextIndexItem ... indexItems) {
        super(AbstractIndex.IndexType.FULL_TEXT);
        this.indexItems = Arrays.asList(indexItems);
    }

    @NonNull
    public FullTextIndex setLanguage(@NonNull String language) {
        this.language = language;
        return this;
    }

    @NonNull
    public FullTextIndex ignoreAccents(boolean ignoreAccents) {
        this.ignoreDiacritics = ignoreAccents;
        return this;
    }

    @Override
    @NonNull
    String getLanguage() {
        return this.language;
    }

    @Override
    boolean isIgnoringDiacritics() {
        return this.ignoreDiacritics;
    }

    @Override
    @NonNull
    List<Object> getJson() {
        ArrayList<Object> items = new ArrayList<Object>();
        for (FullTextIndexItem item : this.indexItems) {
            items.add(item.expression.asJSON());
        }
        return items;
    }
}

