/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.AbstractIndex;
import com.couchbase.lite.IndexConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class FullTextIndexConfiguration
extends IndexConfiguration {
    private String textLanguage = Locale.getDefault().getLanguage();
    private boolean ignoreDiacritics;

    public FullTextIndexConfiguration(String ... expressions) {
        super(AbstractIndex.IndexType.FULL_TEXT, Arrays.asList(expressions));
    }

    FullTextIndexConfiguration(@NonNull List<String> expressions) {
        super(AbstractIndex.IndexType.FULL_TEXT, expressions);
    }

    @NonNull
    public FullTextIndexConfiguration setLanguage(@Nullable String language) {
        this.textLanguage = language;
        return this;
    }

    @NonNull
    public FullTextIndexConfiguration ignoreAccents(boolean ignoreAccents) {
        this.ignoreDiacritics = ignoreAccents;
        return this;
    }

    @Override
    @NonNull
    String getLanguage() {
        return this.textLanguage;
    }

    @Override
    boolean isIgnoringDiacritics() {
        return this.ignoreDiacritics;
    }
}

