/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.AbstractIndex;
import com.couchbase.lite.internal.utils.Preconditions;
import com.couchbase.lite.internal.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class IndexConfiguration
extends AbstractIndex {
    @NonNull
    private final List<String> expressions;

    IndexConfiguration(@NonNull AbstractIndex.IndexType type, String ... expressions) {
        this(type, Arrays.asList(expressions));
    }

    IndexConfiguration(@NonNull AbstractIndex.IndexType type, @NonNull List<String> expressions) {
        super(type, AbstractIndex.QueryLanguage.N1QL);
        this.expressions = Preconditions.assertNotEmpty(expressions, "expression list");
    }

    @Override
    @NonNull
    String getIndexSpec() {
        return StringUtils.join(",", this.expressions);
    }

    @NonNull
    List<String> getExpressions() {
        return new ArrayList<String>(this.expressions);
    }
}

