/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.Array;
import com.couchbase.lite.Blob;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.Fleece;
import com.couchbase.lite.MutableArrayInterface;
import com.couchbase.lite.MutableDictionary;
import com.couchbase.lite.internal.fleece.MArray;
import com.couchbase.lite.internal.fleece.MCollection;
import com.couchbase.lite.internal.fleece.MValue;
import com.couchbase.lite.internal.utils.JSONUtils;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public final class MutableArray
extends Array
implements MutableArrayInterface {
    public MutableArray() {
    }

    public MutableArray(@NonNull List<Object> data) {
        this.setData((List)data);
    }

    public MutableArray(@NonNull String json) {
        this.setJSON(json);
    }

    MutableArray(@NonNull MArray mArray, boolean isMutable) {
        super(mArray, isMutable);
    }

    MutableArray(@NonNull MValue mv, @Nullable MCollection parent) {
        super(mv, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableArray setData(@NonNull List<Object> data) {
        Object object = this.lock;
        synchronized (object) {
            this.internalArray.clear();
            for (Object obj : data) {
                this.checkSelf(obj);
                this.internalArray.append(Fleece.toCBLObject(obj));
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableArray setJSON(@NonNull String json) {
        Object object = this.lock;
        synchronized (object) {
            this.internalArray.clear();
            try {
                this.setData((List)JSONUtils.fromJSON(new JSONArray(json)));
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Failed parsing JSON", e);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableArray setValue(int index, @Nullable Object value) {
        this.checkSelf(value);
        Object object = this.lock;
        synchronized (object) {
            if (Fleece.willMutate(value, this.internalArray.get(index), this.internalArray) && !this.internalArray.set(index, Fleece.toCBLObject(value))) {
                throw new IndexOutOfBoundsException("Array index " + index + " is out of range");
            }
            return this;
        }
    }

    @Override
    @NonNull
    public MutableArray setString(int index, @Nullable String value) {
        return this.setValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray setNumber(int index, @Nullable Number value) {
        return this.setValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray setInt(int index, int value) {
        return this.setValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray setLong(int index, long value) {
        return this.setValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray setFloat(int index, float value) {
        return this.setValue(index, Float.valueOf(value));
    }

    @Override
    @NonNull
    public MutableArray setDouble(int index, double value) {
        return this.setValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray setBoolean(int index, boolean value) {
        return this.setValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray setBlob(int index, @Nullable Blob value) {
        return this.setValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray setDate(int index, @Nullable Date value) {
        return this.setValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray setArray(int index, @Nullable Array value) {
        this.checkSelf(value);
        return this.setValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray setDictionary(int index, @Nullable Dictionary value) {
        return this.setValue(index, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableArray addValue(@Nullable Object value) {
        this.checkSelf(value);
        Object object = this.lock;
        synchronized (object) {
            this.internalArray.append(Fleece.toCBLObject(value));
            return this;
        }
    }

    @Override
    @NonNull
    public MutableArray addString(@Nullable String value) {
        return this.addValue(value);
    }

    @Override
    @NonNull
    public MutableArray addNumber(@Nullable Number value) {
        return this.addValue(value);
    }

    @Override
    @NonNull
    public MutableArray addInt(int value) {
        return this.addValue(value);
    }

    @Override
    @NonNull
    public MutableArray addLong(long value) {
        return this.addValue(value);
    }

    @Override
    @NonNull
    public MutableArray addFloat(float value) {
        return this.addValue(Float.valueOf(value));
    }

    @Override
    @NonNull
    public MutableArray addDouble(double value) {
        return this.addValue(value);
    }

    @Override
    @NonNull
    public MutableArray addBoolean(boolean value) {
        return this.addValue(value);
    }

    @Override
    @NonNull
    public MutableArray addBlob(@Nullable Blob value) {
        return this.addValue(value);
    }

    @Override
    @NonNull
    public MutableArray addDate(@Nullable Date value) {
        return this.addValue(value);
    }

    @Override
    @NonNull
    public MutableArray addArray(@Nullable Array value) {
        this.checkSelf(value);
        return this.addValue(value);
    }

    @Override
    @NonNull
    public MutableArray addDictionary(@Nullable Dictionary value) {
        return this.addValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableArray insertValue(int index, @Nullable Object value) {
        this.checkSelf(value);
        Object object = this.lock;
        synchronized (object) {
            if (!this.internalArray.insert(index, Fleece.toCBLObject(value))) {
                throw new IndexOutOfBoundsException("Array index " + index + " is out of range");
            }
            return this;
        }
    }

    @Override
    @NonNull
    public MutableArray insertString(int index, @Nullable String value) {
        return this.insertValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray insertNumber(int index, @Nullable Number value) {
        return this.insertValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray insertInt(int index, int value) {
        return this.insertValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray insertLong(int index, long value) {
        return this.insertValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray insertFloat(int index, float value) {
        return this.insertValue(index, Float.valueOf(value));
    }

    @Override
    @NonNull
    public MutableArray insertDouble(int index, double value) {
        return this.insertValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray insertBoolean(int index, boolean value) {
        return this.insertValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray insertBlob(int index, @Nullable Blob value) {
        return this.insertValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray insertDate(int index, @Nullable Date value) {
        return this.insertValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray insertArray(int index, @Nullable Array value) {
        this.checkSelf(value);
        return this.insertValue(index, value);
    }

    @Override
    @NonNull
    public MutableArray insertDictionary(int index, @Nullable Dictionary value) {
        return this.insertValue(index, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableArray remove(int index) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.internalArray.remove(index)) {
                throw new IndexOutOfBoundsException("Array index " + index + " is out of range");
            }
            return this;
        }
    }

    @Override
    @Nullable
    public MutableArray getArray(int index) {
        return (MutableArray)super.getArray(index);
    }

    @Override
    @NonNull
    public String toJSON() {
        throw new IllegalStateException("Mutable objects may not be encoded as JSON");
    }

    @Override
    @Nullable
    public MutableDictionary getDictionary(int index) {
        return (MutableDictionary)super.getDictionary(index);
    }

    private void checkSelf(Object value) {
        if (value == this) {
            throw new IllegalArgumentException("Arrays cannot ba added to themselves");
        }
    }
}

