/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.AbstractDatabase;
import com.couchbase.lite.Array;
import com.couchbase.lite.ArrayInterface;
import com.couchbase.lite.Blob;
import com.couchbase.lite.CBLConverter;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.DictionaryInterface;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.ResultSet;
import com.couchbase.lite.internal.DbContext;
import com.couchbase.lite.internal.core.C4QueryEnumerator;
import com.couchbase.lite.internal.fleece.FLArrayIterator;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.fleece.JSONEncoder;
import com.couchbase.lite.internal.fleece.MRoot;
import com.couchbase.lite.internal.utils.JSONUtils;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Result
implements ArrayInterface,
DictionaryInterface,
Iterable<String> {
    @NonNull
    private final ResultSet rs;
    @NonNull
    private final List<FLValue> values;
    @NonNull
    private final long missingColumns;
    @NonNull
    private final DbContext context;

    Result(@NonNull ResultSet rs, @NonNull C4QueryEnumerator c4enum, @NonNull DbContext context) {
        this.rs = rs;
        this.values = this.extractColumns(c4enum.getColumns());
        this.missingColumns = c4enum.getMissingColumns();
        this.context = context;
    }

    @Override
    public int count() {
        return this.rs.getColumnCount();
    }

    @Override
    @Nullable
    public Object getValue(int index) {
        this.assertInBounds(index);
        return this.fleeceValueToObject(index);
    }

    @Override
    @Nullable
    public String getString(int index) {
        this.assertInBounds(index);
        Object obj = this.fleeceValueToObject(index);
        return !(obj instanceof String) ? null : (String)obj;
    }

    @Override
    @Nullable
    public Number getNumber(int index) {
        this.assertInBounds(index);
        return CBLConverter.asNumber(this.fleeceValueToObject(index));
    }

    @Override
    public int getInt(int index) {
        this.assertInBounds(index);
        FLValue flValue = this.values.get(index);
        return flValue == null ? 0 : (int)flValue.asInt();
    }

    @Override
    public long getLong(int index) {
        this.assertInBounds(index);
        FLValue flValue = this.values.get(index);
        return flValue == null ? 0L : flValue.asInt();
    }

    @Override
    public float getFloat(int index) {
        this.assertInBounds(index);
        FLValue flValue = this.values.get(index);
        return flValue == null ? 0.0f : flValue.asFloat();
    }

    @Override
    public double getDouble(int index) {
        this.assertInBounds(index);
        FLValue flValue = this.values.get(index);
        return flValue == null ? 0.0 : flValue.asDouble();
    }

    @Override
    public boolean getBoolean(int index) {
        this.assertInBounds(index);
        FLValue flValue = this.values.get(index);
        return flValue != null && flValue.asBool();
    }

    @Override
    @Nullable
    public Blob getBlob(int index) {
        this.assertInBounds(index);
        Object obj = this.fleeceValueToObject(index);
        return !(obj instanceof Blob) ? null : (Blob)obj;
    }

    @Override
    @Nullable
    public Date getDate(int index) {
        this.assertInBounds(index);
        return JSONUtils.toDate(this.getString(index));
    }

    @Override
    @Nullable
    public Array getArray(int index) {
        this.assertInBounds(index);
        Object obj = this.fleeceValueToObject(index);
        return !(obj instanceof Array) ? null : (Array)obj;
    }

    @Override
    @Nullable
    public Dictionary getDictionary(int index) {
        this.assertInBounds(index);
        Object obj = this.fleeceValueToObject(index);
        return !(obj instanceof Dictionary) ? null : (Dictionary)obj;
    }

    @Override
    @NonNull
    public List<Object> toList() {
        int nVals = this.count();
        ArrayList<Object> array = new ArrayList<Object>(nVals);
        for (int i = 0; i < nVals; ++i) {
            array.add(this.values.get(i).asObject());
        }
        return array;
    }

    @Override
    @NonNull
    public List<String> getKeys() {
        return this.rs.getColumnNames();
    }

    @Override
    @Nullable
    public Object getValue(@NonNull String key) {
        int index = this.indexForColumnName(Preconditions.assertNotNull(key, "key"));
        return !this.isInBounds(index) ? null : this.getValue(index);
    }

    @Override
    @Nullable
    public String getString(@NonNull String key) {
        int index = this.indexForColumnName(Preconditions.assertNotNull(key, "key"));
        return !this.isInBounds(index) ? null : this.getString(index);
    }

    @Override
    @Nullable
    public Number getNumber(@NonNull String key) {
        int index = this.indexForColumnName(Preconditions.assertNotNull(key, "key"));
        return !this.isInBounds(index) ? (Number)null : (Number)this.getNumber(index);
    }

    @Override
    public int getInt(@NonNull String key) {
        int index = this.indexForColumnName(Preconditions.assertNotNull(key, "key"));
        return !this.isInBounds(index) ? 0 : this.getInt(index);
    }

    @Override
    public long getLong(@NonNull String key) {
        int index = this.indexForColumnName(Preconditions.assertNotNull(key, "key"));
        return !this.isInBounds(index) ? 0L : this.getLong(index);
    }

    @Override
    public float getFloat(@NonNull String key) {
        int index = this.indexForColumnName(Preconditions.assertNotNull(key, "key"));
        return !this.isInBounds(index) ? 0.0f : this.getFloat(index);
    }

    @Override
    public double getDouble(@NonNull String key) {
        int index = this.indexForColumnName(Preconditions.assertNotNull(key, "key"));
        return !this.isInBounds(index) ? 0.0 : this.getDouble(index);
    }

    @Override
    public boolean getBoolean(@NonNull String key) {
        int index = this.indexForColumnName(Preconditions.assertNotNull(key, "key"));
        return this.isInBounds(index) && this.getBoolean(index);
    }

    @Override
    @Nullable
    public Blob getBlob(@NonNull String key) {
        int index = this.indexForColumnName(Preconditions.assertNotNull(key, "key"));
        return !this.isInBounds(index) ? null : this.getBlob(index);
    }

    @Override
    @Nullable
    public Date getDate(@NonNull String key) {
        int index = this.indexForColumnName(Preconditions.assertNotNull(key, "key"));
        return !this.isInBounds(index) ? null : this.getDate(index);
    }

    @Override
    @Nullable
    public Array getArray(@NonNull String key) {
        int index = this.indexForColumnName(Preconditions.assertNotNull(key, "key"));
        return !this.isInBounds(index) ? null : this.getArray(index);
    }

    @Override
    @Nullable
    public Dictionary getDictionary(@NonNull String key) {
        int index = this.indexForColumnName(Preconditions.assertNotNull(key, "key"));
        return !this.isInBounds(index) ? null : this.getDictionary(index);
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        int nVals = this.values.size();
        HashMap<String, Object> dict = new HashMap<String, Object>(nVals);
        for (String name : this.rs.getColumnNames()) {
            int i = this.indexForColumnName(name);
            if (i < 0 || i >= nVals) continue;
            dict.put(name, this.values.get(i).asObject());
        }
        return dict;
    }

    @Override
    @NonNull
    public String toJSON() {
        int nVals = this.values.size();
        JSONEncoder enc = new JSONEncoder();
        try {
            enc.beginDict(nVals);
            for (String columnName : this.rs.getColumnNames()) {
                int i = this.indexForColumnName(columnName);
                if (i < 0 || i >= nVals) continue;
                enc.writeKey(columnName);
                enc.writeValue(this.values.get(i));
            }
            enc.endDict();
            String string = enc.finishJSON();
            enc.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    enc.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (LiteCoreException e) {
                throw new IllegalStateException("Failed marshalling Document to JSON", CouchbaseLiteException.convertException(e));
            }
        }
    }

    @Override
    public boolean contains(@NonNull String key) {
        return this.isInBounds(this.indexForColumnName(Preconditions.assertNotNull(key, "key")));
    }

    @Override
    @NonNull
    public Iterator<String> iterator() {
        return this.getKeys().iterator();
    }

    private int indexForColumnName(@NonNull String name) {
        int index = this.rs.getColumnIndex(name);
        if (index < 0) {
            return -1;
        }
        return (this.missingColumns & 1L << index) == 0L ? index : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object fleeceValueToObject(int index) {
        FLValue value = this.values.get(index);
        if (value == null) {
            return null;
        }
        AbstractDatabase db = Preconditions.assertNotNull(this.rs.getQuery().getDatabase(), "db");
        MRoot root = new MRoot(this.context, value, false);
        Object object = db.getDbLock();
        synchronized (object) {
            return root.asNative();
        }
    }

    @NonNull
    private List<FLValue> extractColumns(@NonNull FLArrayIterator columns) {
        ArrayList<FLValue> values = new ArrayList<FLValue>();
        int count = this.rs.getColumnCount();
        for (int i = 0; i < count; ++i) {
            values.add(columns.getValueAt(i));
        }
        return values;
    }

    private boolean isInBounds(int index) {
        return index >= 0 && index < this.count();
    }

    private void assertInBounds(int index) {
        if (!this.isInBounds(index)) {
            throw new ArrayIndexOutOfBoundsException("index " + index + " must be between 0 and " + this.count());
        }
    }
}

