/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.AbstractDatabase;
import com.couchbase.lite.AbstractQuery;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.Result;
import com.couchbase.lite.internal.DbContext;
import com.couchbase.lite.internal.core.C4QueryEnumerator;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ResultSet
implements Iterable<Result>,
AutoCloseable {
    private static final LogDomain DOMAIN = LogDomain.QUERY;
    @NonNull
    private final Object lock = new Object();
    @NonNull
    private final AbstractQuery query;
    @NonNull
    private final Map<String, Integer> columnNames;
    @NonNull
    private final DbContext context;
    @GuardedBy(value="lock")
    @Nullable
    private C4QueryEnumerator c4enum;
    @GuardedBy(value="lock")
    private boolean isAllEnumerated;

    ResultSet(@NonNull AbstractQuery query, @Nullable C4QueryEnumerator c4enum, @NonNull Map<String, Integer> cols) {
        this.query = query;
        this.columnNames = cols;
        this.context = new DbContext(query.getDatabase());
        this.c4enum = c4enum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet(@NonNull ResultSet other) {
        this.query = other.query;
        this.columnNames = other.columnNames;
        this.context = other.context;
        Object object = other.lock;
        synchronized (object) {
            this.c4enum = other.c4enum == null ? null : other.c4enum.copy();
            this.isAllEnumerated = other.isAllEnumerated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Result next() {
        String msg;
        Preconditions.assertNotNull(this.query, "query");
        LiteCoreException err = null;
        Object object = this.lock;
        synchronized (object) {
            block8: {
                try {
                    if (this.c4enum == null) {
                        return null;
                    }
                    if (this.isAllEnumerated) {
                        msg = "ResultSetAlreadyEnumerated";
                        break block8;
                    }
                    if (!this.c4enum.next()) {
                        this.isAllEnumerated = true;
                        msg = "End of query enumeration";
                        break block8;
                    }
                    return new Result(this, this.c4enum, this.context);
                }
                catch (LiteCoreException e) {
                    msg = "Error enumerating query";
                    err = e;
                }
            }
        }
        Log.w(DOMAIN, msg, err);
        return null;
    }

    @NonNull
    public List<Result> allResults() {
        Result result;
        ArrayList<Result> results = new ArrayList<Result>();
        while ((result = this.next()) != null) {
            results.add(result);
        }
        return results;
    }

    @Override
    @NonNull
    public Iterator<Result> iterator() {
        return this.allResults().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        C4QueryEnumerator qEnum;
        Object object = this.lock;
        synchronized (object) {
            if (this.c4enum == null) {
                return;
            }
            qEnum = this.c4enum;
            this.c4enum = null;
        }
        object = this.getDbLock();
        synchronized (object) {
            qEnum.close();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.c4enum != null) {
                this.c4enum.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    @NonNull
    ResultSet copy() {
        return new ResultSet(this);
    }

    @NonNull
    AbstractQuery getQuery() {
        return this.query;
    }

    int getColumnCount() {
        return this.columnNames.size();
    }

    @NonNull
    List<String> getColumnNames() {
        return new ArrayList<String>(this.columnNames.keySet());
    }

    int getColumnIndex(@NonNull String name) {
        Integer idx = this.columnNames.get(name);
        return idx == null ? -1 : idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ResultSet refresh() throws CouchbaseLiteException {
        C4QueryEnumerator newEnum;
        Preconditions.assertNotNull(this.query, "query");
        Object object = this.getDbLock();
        synchronized (object) {
            Object object2 = this.lock;
            synchronized (object2) {
                if (this.c4enum == null) {
                    return null;
                }
                try {
                    newEnum = this.c4enum.refresh();
                }
                catch (LiteCoreException e) {
                    throw CouchbaseLiteException.convertException(e);
                }
            }
        }
        return newEnum == null ? null : new ResultSet(this.query, newEnum, this.columnNames);
    }

    @NonNull
    private Object getDbLock() {
        AbstractDatabase db;
        AbstractQuery q = this.query;
        if (q != null && (db = q.getDatabase()) != null) {
            return db.getDbLock();
        }
        throw new IllegalStateException("Could not obtain db lock");
    }
}

