/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal;

import android.support.annotation.NonNull;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

final class NativeLibrary {
    private static final String JAVA_PATH_SEPARATOR = "/";
    private static final String RESOURCE_BASE_DIR = "libs";
    private static final String ARCH_X86 = "x86_64";
    private static final String LIB_DIR_MAC = "macos";
    private static final String LIB_DIR_LINUX = "linux";
    private static final String LIB_DIR_WINDOWS = "windows";
    private static final String DIGEST_MD5 = "MD5";
    private static final AtomicBoolean LOADED = new AtomicBoolean(false);
    @NonNull
    private static final List<String> LIBRARIES;

    private NativeLibrary() {
    }

    static void load(@NonNull File scratchDir) {
        File targetDir;
        CouchbaseLiteInternal.requireInit("Cannot load native libraries");
        if (LOADED.getAndSet(true)) {
            return;
        }
        String osName = System.getProperty("os.name");
        String osDir = NativeLibrary.getOsDir(osName);
        String resDirPath = "/libs/" + osDir + JAVA_PATH_SEPARATOR + ARCH_X86;
        ArrayList<String> libs = new ArrayList<String>(LIBRARIES.size());
        for (String lib : LIBRARIES) {
            libs.add(System.mapLibraryName(lib));
        }
        byte[] buf = new byte[1024];
        try {
            targetDir = new File(scratchDir, String.format("%032x", NativeLibrary.computeTargetDirectory(resDirPath, libs, buf))).getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot compute target directory name", e);
        }
        for (String lib : libs) {
            String libPath;
            try {
                libPath = NativeLibrary.extract(lib, resDirPath, targetDir, buf);
                if (!LIB_DIR_WINDOWS.equals(osDir)) {
                    NativeLibrary.setPermissions(libPath);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot extract library resource: " + lib + " to " + targetDir, e);
            }
            try {
                System.load(libPath);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Cannot load native library " + lib + " @" + libPath + " for " + osName + JAVA_PATH_SEPARATOR + System.getProperty("os.arch"), e);
            }
        }
    }

    @NonNull
    private static BigInteger computeTargetDirectory(@NonNull String resDirPath, @NonNull List<String> libs, @NonNull byte[] buf) throws IOException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(DIGEST_MD5);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No such digest algorithm: MD5", e);
        }
        for (String lib : libs) {
            String path = resDirPath + JAVA_PATH_SEPARATOR + lib + "." + DIGEST_MD5;
            InputStream in = NativeLibrary.class.getResourceAsStream(path);
            try {
                int bytesRead;
                if (in == null) {
                    throw new IOException("Cannot find MD5 for library at " + path);
                }
                while ((bytesRead = in.read(buf)) != -1) {
                    md.update(buf, 0, bytesRead);
                }
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
        return new BigInteger(1, md.digest());
    }

    @NonNull
    private static String getOsDir(@NonNull String osName) {
        String os = osName.toLowerCase(Locale.getDefault());
        if (os.contains("mac")) {
            return LIB_DIR_MAC;
        }
        if (os.contains(LIB_DIR_LINUX)) {
            return LIB_DIR_LINUX;
        }
        if (os.contains(LIB_DIR_WINDOWS)) {
            return LIB_DIR_WINDOWS;
        }
        throw new IllegalStateException("Unrecongnized OS: " + osName);
    }

    private static void setPermissions(String targetPath) throws IOException {
        try {
            Runtime.getRuntime().exec(new String[]{"chmod", "755", targetPath}).waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @NonNull
    private static String extract(@NonNull String lib, @NonNull String resDirPath, @NonNull File targetDir, @NonNull byte[] buf) throws IOException {
        File targetFile = new File(targetDir, lib);
        String targetPath = targetFile.getCanonicalPath();
        if (targetFile.exists()) {
            return targetPath;
        }
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            throw new IOException("Cannot create target directory: " + targetDir.getCanonicalPath());
        }
        String resPath = resDirPath + JAVA_PATH_SEPARATOR + lib;
        try (InputStream in = NativeLibrary.class.getResourceAsStream(resPath);
             OutputStream out = Files.newOutputStream(targetFile.toPath(), new OpenOption[0]);){
            int bytesRead;
            if (in == null) {
                throw new IOException("Cannot find resource for native library at " + resPath);
            }
            while ((bytesRead = in.read(buf)) != -1) {
                out.write(buf, 0, bytesRead);
            }
        }
        return targetPath;
    }

    static {
        ArrayList<String> l = new ArrayList<String>();
        l.add("LiteCore");
        l.add("LiteCoreJNI");
        LIBRARIES = Collections.unmodifiableList(l);
    }
}

