/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4BlobKey;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.utils.Preconditions;

public class C4BlobWriteStream
extends C4NativePeer {
    C4BlobWriteStream(long peer) {
        super(peer);
    }

    public void write(@NonNull byte[] bytes) throws LiteCoreException {
        Preconditions.assertNotNull(bytes, "bytes");
        this.write(bytes, bytes.length);
    }

    public void write(@NonNull byte[] bytes, int len) throws LiteCoreException {
        Preconditions.assertNotNull(bytes, "bytes");
        if (len <= 0) {
            return;
        }
        C4BlobWriteStream.write(this.getPeer(), bytes, len);
    }

    @NonNull
    public C4BlobKey computeBlobKey() throws LiteCoreException {
        return new C4BlobKey(C4BlobWriteStream.computeBlobKey(this.getPeer()));
    }

    public void install() throws LiteCoreException {
        C4BlobWriteStream.install(this.getPeer());
    }

    @Override
    @CallSuper
    public void close() {
        this.closePeer(null);
    }

    protected void finalize() throws Throwable {
        try {
            this.closePeer(LogDomain.DATABASE);
        }
        finally {
            super.finalize();
        }
    }

    private void closePeer(@Nullable LogDomain domain) {
        this.releasePeer(domain, C4BlobWriteStream::close);
    }

    private static native void write(long var0, byte[] var2, int var3) throws LiteCoreException;

    private static native long computeBlobKey(long var0) throws LiteCoreException;

    private static native void install(long var0) throws LiteCoreException;

    private static native void close(long var0);
}

