/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4DatabaseChange;
import com.couchbase.lite.internal.core.C4DatabaseObserverListener;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.support.Log;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class C4DatabaseObserver
extends C4NativePeer {
    private static final Map<Long, C4DatabaseObserver> REVERSE_LOOKUP_TABLE = Collections.synchronizedMap(new HashMap());
    @NonNull
    private final C4DatabaseObserverListener listener;
    @NonNull
    private final Object context;

    static void callback(long peer) {
        Log.d(LogDomain.DATABASE, "C4DatabaseObserver.callback @%x", peer);
        C4DatabaseObserver obs = REVERSE_LOOKUP_TABLE.get(peer);
        if (obs == null) {
            return;
        }
        obs.listener.callback(obs, obs.context);
    }

    @NonNull
    static C4DatabaseObserver newObserver(long db, @NonNull C4DatabaseObserverListener listener, @NonNull Object context) {
        C4DatabaseObserver observer = new C4DatabaseObserver(db, listener, context);
        REVERSE_LOOKUP_TABLE.put(observer.getPeer(), observer);
        return observer;
    }

    C4DatabaseObserver(long db, @NonNull C4DatabaseObserverListener listener, @NonNull Object context) {
        super(C4DatabaseObserver.create(db));
        this.listener = listener;
        this.context = context;
    }

    @Nullable
    public C4DatabaseChange[] getChanges(int maxChanges) {
        return C4DatabaseObserver.getChanges(this.getPeer(), maxChanges);
    }

    @Override
    @CallSuper
    public void close() {
        REVERSE_LOOKUP_TABLE.remove(this.getPeerUnchecked());
        this.closePeer(null);
    }

    protected void finalize() throws Throwable {
        try {
            this.closePeer(LogDomain.DATABASE);
        }
        finally {
            super.finalize();
        }
    }

    private void closePeer(@Nullable LogDomain domain) {
        this.releasePeer(domain, C4DatabaseObserver::free);
    }

    private static native long create(long var0);

    @NonNull
    private static native C4DatabaseChange[] getChanges(long var0, int var2);

    private static native void free(long var0);
}

