/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.NonNull;
import com.couchbase.lite.CouchbaseLiteException;
import java.nio.charset.StandardCharsets;

public final class C4Key {
    private static final String DEFAULT_PBKDF2_KEY_SALT = "Salty McNaCl";
    private static final int DEFAULT_PBKDF2_KEY_ROUNDS = 64000;

    private C4Key() {
    }

    @NonNull
    public static byte[] getPbkdf2Key(@NonNull String password) throws CouchbaseLiteException {
        byte[] key = C4Key.pbkdf2(password, DEFAULT_PBKDF2_KEY_SALT.getBytes(StandardCharsets.UTF_8), 64000, 32);
        if (key != null) {
            return key;
        }
        throw new CouchbaseLiteException("Could not generate key", "CouchbaseLite", 22);
    }

    @NonNull
    public static byte[] getCoreKey(@NonNull String password) throws CouchbaseLiteException {
        byte[] key = C4Key.deriveKeyFromPassword(password, 1);
        if (key != null) {
            return key;
        }
        throw new CouchbaseLiteException("Could not generate key", "CouchbaseLite", 22);
    }

    @NonNull
    private static native byte[] pbkdf2(@NonNull String var0, @NonNull byte[] var1, int var2, int var3);

    @NonNull
    private static native byte[] deriveKeyFromPassword(@NonNull String var0, int var1);
}

