/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;

public abstract class C4NativePeer
implements AutoCloseable {
    private static final String HANDLE_NAME = "peer handle";
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private volatile long peer;
    @GuardedBy(value="lock")
    private Exception closedAt;

    protected C4NativePeer() {
    }

    protected C4NativePeer(long peer) {
        this.setPeerInternal(peer);
    }

    @NonNull
    public String toString() {
        return Long.toHexString(this.peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected final <T, E extends Exception> T withPeer(@NonNull T def, @NonNull Fn.FunctionThrows<Long, T, E> fn) throws E {
        Object object = this.getPeerLock();
        synchronized (object) {
            long peer = this.get();
            if (peer == 0L) {
                this.logBadCall();
                return def;
            }
            T val = fn.apply(peer);
            T t = val == null ? def : val;
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final <T, E extends Exception> T withPeerOrNull(@NonNull Fn.FunctionThrows<Long, T, E> fn) throws E {
        Object object = this.getPeerLock();
        synchronized (object) {
            long peer = this.get();
            if (peer == 0L) {
                this.logBadCall();
                return null;
            }
            return fn.apply(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void releasePeer() {
        Object object = this.lock;
        synchronized (object) {
            this.releasePeerLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <E extends Exception> void releasePeer(@Nullable LogDomain domain, @NonNull Fn.ConsumerThrows<Long, E> fn) throws E {
        long peer;
        Object object = this.lock;
        synchronized (object) {
            peer = this.releasePeerLocked();
            if (peer == 0L) {
                return;
            }
            fn.accept(peer);
        }
        if (domain != null) {
            Log.d(domain, "Peer %x for %s was not closed", peer, this.getClass().getSimpleName());
        }
    }

    protected final void setPeer(long peer) {
        this.setPeerInternal(peer);
    }

    protected final long getPeerUnchecked() {
        long peer = this.get();
        if (peer == 0L) {
            Log.v(LogDomain.DATABASE, "Unchecked peer is 0", new Exception("peer is 0"));
        }
        return peer;
    }

    protected final long getPeer() {
        long peer = this.get();
        if (peer == 0L) {
            this.logBadCall();
            throw new IllegalStateException("Operation on closed native peer");
        }
        return peer;
    }

    @NonNull
    protected final Object getPeerLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long get() {
        Object object = this.getPeerLock();
        synchronized (object) {
            return this.peer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPeerInternal(long peer) {
        Preconditions.assertNotZero(peer, HANDLE_NAME);
        Object object = this.getPeerLock();
        synchronized (object) {
            Preconditions.assertZero(this.peer, HANDLE_NAME);
            this.peer = peer;
        }
    }

    @GuardedBy(value="lock")
    private long releasePeerLocked() {
        long peer = this.peer;
        if (this.peer != 0L && CouchbaseLiteInternal.debugging()) {
            this.closedAt = new Exception();
        }
        this.peer = 0L;
        return peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logBadCall() {
        Exception closedLoc;
        Log.e(LogDomain.DATABASE, "Operation on closed native peer", new Exception());
        Object object = this.getPeerLock();
        synchronized (object) {
            closedLoc = this.closedAt;
        }
        if (closedLoc != null) {
            Log.e(LogDomain.DATABASE, "Closed at", closedLoc);
        }
    }
}

