/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.couchbase.lite.AbstractIndex;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4Database;
import com.couchbase.lite.internal.core.C4FullTextMatch;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.core.C4QueryEnumerator;
import com.couchbase.lite.internal.core.C4QueryOptions;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.support.Log;

public class C4Query
extends C4NativePeer {
    public static void createIndex(@NonNull C4Database db, @NonNull String name, @NonNull String queryExpression, @NonNull AbstractIndex.QueryLanguage queryLanguage, @NonNull AbstractIndex.IndexType indexType, @Nullable String language, boolean ignoreDiacritics) throws LiteCoreException {
        Log.d(LogDomain.QUERY, "creating index: " + queryExpression);
        C4Query.createIndex(db.getPeer(), name, queryExpression, queryLanguage.getValue(), indexType.getValue(), language, ignoreDiacritics);
    }

    @NonNull
    public static FLValue getIndexInfo(@NonNull C4Database db) throws LiteCoreException {
        return new FLValue(C4Query.getIndexInfo(db.getPeer()));
    }

    public static void deleteIndex(@NonNull C4Database db, String name) throws LiteCoreException {
        C4Query.deleteIndex(db.getPeer(), name);
    }

    C4Query(long db, @NonNull AbstractIndex.QueryLanguage queryLanguage, @NonNull String expression) throws LiteCoreException {
        super(C4Query.createQuery(db, queryLanguage.getValue(), expression));
    }

    @Override
    @CallSuper
    public void close() {
        this.closePeer(null);
    }

    @Nullable
    public String explain() {
        return this.withPeerOrNull(C4Query::explain);
    }

    @Nullable
    public C4QueryEnumerator run(@NonNull C4QueryOptions opts, @NonNull FLSliceResult params) throws LiteCoreException {
        return this.withPeerOrNull(h -> new C4QueryEnumerator(C4Query.run(h, opts.isRankFullText(), params.getHandle())));
    }

    @Nullable
    public byte[] getFullTextMatched(@NonNull C4FullTextMatch match) throws LiteCoreException {
        return this.withPeerOrNull(h -> C4Query.getFullTextMatched(h, match.getPeer()));
    }

    protected void finalize() throws Throwable {
        try {
            this.closePeer(LogDomain.QUERY);
        }
        finally {
            super.finalize();
        }
    }

    public int getColumnCount() {
        return this.withPeer(0, C4Query::columnCount);
    }

    @Nullable
    public String getColumnNameForIndex(int idx) {
        return this.withPeerOrNull(peer -> C4Query.columnName(peer, idx));
    }

    @Nullable
    @VisibleForTesting
    C4QueryEnumerator run(@NonNull C4QueryOptions opts) throws LiteCoreException {
        try (FLSliceResult params = FLSliceResult.getManagedSliceResult();){
            C4QueryEnumerator c4QueryEnumerator = this.run(opts, params);
            return c4QueryEnumerator;
        }
    }

    private void closePeer(@Nullable LogDomain domain) {
        this.releasePeer(domain, C4Query::free);
    }

    private static native long getIndexInfo(long var0) throws LiteCoreException;

    private static native void deleteIndex(long var0, String var2) throws LiteCoreException;

    private static native boolean createIndex(long var0, String var2, String var3, int var4, int var5, String var6, boolean var7) throws LiteCoreException;

    private static native long createQuery(long var0, int var2, String var3) throws LiteCoreException;

    private static native void free(long var0);

    @Nullable
    private static native String explain(long var0);

    private static native int columnCount(long var0);

    @Nullable
    private static native String columnName(long var0, int var2);

    private static native long run(long var0, boolean var2, long var3) throws LiteCoreException;

    @NonNull
    private static native byte[] getFullTextMatched(long var0, long var2) throws LiteCoreException;
}

