/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.CallSuper;
import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.AbstractReplicator;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.SocketFactory;
import com.couchbase.lite.internal.core.C4Database;
import com.couchbase.lite.internal.core.C4DocumentEnded;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.core.C4ReplicationFilter;
import com.couchbase.lite.internal.core.C4ReplicatorListener;
import com.couchbase.lite.internal.core.C4ReplicatorStatus;
import com.couchbase.lite.internal.core.C4Socket;
import com.couchbase.lite.internal.exec.ClientTask;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class C4Replicator
extends C4NativePeer {
    public static final String WEBSOCKET_SCHEME = "ws";
    public static final String WEBSOCKET_SECURE_CONNECTION_SCHEME = "wss";
    public static final String MESSAGE_SCHEME = "x-msg-endpt";
    public static final String C4_REPLICATOR_SCHEME_2 = "blip";
    public static final String C4_REPLICATOR_TLS_SCHEME_2 = "blips";
    public static final String REPLICATOR_OPTION_DOC_IDS = "docIDs";
    public static final String REPLICATOR_OPTION_CHANNELS = "channels";
    public static final String REPLICATOR_OPTION_FILTER = "filter";
    public static final String REPLICATOR_OPTION_FILTER_PARAMS = "filterParams";
    public static final String REPLICATOR_OPTION_SKIP_DELETED = "skipDeleted";
    public static final String REPLICATOR_OPTION_NO_INCOMING_CONFLICTS = "noIncomingConflicts";
    public static final String REPLICATOR_OPTION_OUTGOING_CONFLICTS = "outgoingConflicts";
    public static final String REPLICATOR_CHECKPOINT_INTERVAL = "checkpointInterval";
    public static final String REPLICATOR_OPTION_REMOTE_DB_UNIQUE_ID = "remoteDBUniqueID";
    public static final String REPLICATOR_OPTION_PROGRESS_LEVEL = "progress";
    public static final String REPLICATOR_OPTION_DISABLE_DELTAS = "noDeltas";
    public static final String REPLICATOR_OPTION_MAX_RETRIES = "maxRetries";
    public static final String REPLICATOR_OPTION_MAX_RETRY_INTERVAL = "maxRetryInterval";
    public static final String REPLICATOR_OPTION_ENABLE_AUTO_PURGE = "autoPurge";
    public static final String REPLICATOR_OPTION_ROOT_CERTS = "rootCerts";
    public static final String REPLICATOR_OPTION_PINNED_SERVER_CERT = "pinnedCert";
    public static final String REPLICATOR_OPTION_SELF_SIGNED_SERVER_CERT = "onlySelfSignedServer";
    public static final String REPLICATOR_OPTION_EXTRA_HEADERS = "headers";
    public static final String REPLICATOR_OPTION_COOKIES = "cookies";
    public static final String REPLICATOR_OPTION_AUTHENTICATION = "auth";
    public static final String REPLICATOR_OPTION_PROXY_SERVER = "proxy";
    public static final String REPLICATOR_HEARTBEAT_INTERVAL = "heartbeat";
    public static final String SOCKET_OPTION_WS_PROTOCOLS = "WS-Protocols";
    static final String REPLICATOR_AUTH_OPTION = "auth";
    public static final String REPLICATOR_AUTH_TYPE = "type";
    public static final String REPLICATOR_AUTH_USER_NAME = "username";
    public static final String REPLICATOR_AUTH_PASSWORD = "password";
    public static final String REPLICATOR_AUTH_CLIENT_CERT = "clientCert";
    public static final String REPLICATOR_AUTH_CLIENT_CERT_KEY = "clientCertKey";
    public static final String REPLICATOR_AUTH_TOKEN = "token";
    public static final String AUTH_TYPE_BASIC = "Basic";
    public static final String AUTH_TYPE_SESSION = "Session";
    public static final String AUTH_TYPE_OPEN_ID_CONNECT = "OpenID Connect";
    public static final String AUTH_TYPE_FACEBOOK = "Facebook";
    public static final String AUTH_TYPE_CLIENT_CERT = "Client Cert";
    public static final int PROGRESS_OVERALL = 0;
    public static final int PROGRESS_PER_DOC = 1;
    public static final int PROGRESS_PER_ATTACHMENT = 2;
    private static final Object CLASS_LOCK = new Object();
    @NonNull
    @GuardedBy(value="CLASS_LOCK")
    private static final Map<Long, C4Replicator> REVERSE_LOOKUP_TABLE = new HashMap<Long, C4Replicator>();
    @NonNull
    private final Object replicatorContext;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    @Nullable
    private final SocketFactory socketFactoryContext;
    @Nullable
    private final C4ReplicatorListener listener;
    @Nullable
    private final C4ReplicationFilter pushFilter;
    @Nullable
    private final C4ReplicationFilter pullFilter;

    static void statusChangedCallback(long peer, @Nullable C4ReplicatorStatus status) {
        C4Replicator repl = C4Replicator.getReplicatorForHandle(peer);
        Log.d(LogDomain.REPLICATOR, "C4Replicator.statusChangedCallback @0x%x, status: %s", peer, status);
        if (repl == null) {
            return;
        }
        C4ReplicatorListener listener = repl.listener;
        if (listener != null) {
            listener.statusChanged(repl, status, repl.replicatorContext);
        }
    }

    static void documentEndedCallback(long peer, boolean pushing, C4DocumentEnded ... documentsEnded) {
        Log.d(LogDomain.REPLICATOR, "C4Replicator.documentEndedCallback @0x%x, pushing: %s", peer, pushing);
        C4Replicator repl = C4Replicator.getReplicatorForHandle(peer);
        if (repl == null) {
            return;
        }
        C4ReplicatorListener listener = repl.listener;
        if (listener != null) {
            listener.documentEnded(repl, pushing, documentsEnded, repl.replicatorContext);
        }
    }

    static boolean validationFunction(@Nullable String docID, @Nullable String revID, int flags, long dict, boolean isPush, Object ctxt) {
        C4ReplicationFilter filter;
        Log.d(LogDomain.REPLICATOR, "Running %s filter for doc %s@%s, repl %s", isPush ? "push" : "pull", docID, revID, ctxt);
        if (!(ctxt instanceof AbstractReplicator)) {
            Log.w(LogDomain.REPLICATOR, "Validation function called with unrecognized context: " + ctxt);
            return true;
        }
        AbstractReplicator repl = (AbstractReplicator)ctxt;
        C4Replicator c4Repl = repl.getC4Replicator();
        if (c4Repl == null) {
            return true;
        }
        C4ReplicationFilter c4ReplicationFilter = filter = isPush ? c4Repl.pushFilter : c4Repl.pullFilter;
        if (filter == null) {
            return true;
        }
        ClientTask<Boolean> task = new ClientTask<Boolean>(() -> filter.validationFunction(docID, revID, flags, dict, isPush, repl));
        task.execute();
        Exception err = task.getFailure();
        if (err != null) {
            Log.w(LogDomain.REPLICATOR, "Replication filter failed", err);
            return false;
        }
        Boolean accepted = task.getResult();
        return accepted != null && accepted != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    static C4Replicator createRemoteReplicator(long db, @Nullable String scheme, @Nullable String host, int port, @Nullable String path, @Nullable String remoteDatabaseName, int push, int pull, @Nullable byte[] options, @Nullable C4ReplicatorListener listener, @Nullable C4ReplicationFilter pushFilter, @Nullable C4ReplicationFilter pullFilter, @NonNull AbstractReplicator replicatorContext, @Nullable SocketFactory socketFactoryContext, int framing) throws LiteCoreException {
        C4Replicator replicator;
        Object object = CLASS_LOCK;
        synchronized (object) {
            replicator = new C4Replicator(db, scheme, host, port, path, remoteDatabaseName, push, pull, options, listener, pushFilter, pullFilter, replicatorContext, socketFactoryContext, framing);
            C4Replicator.bind(replicator);
        }
        return replicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    static C4Replicator createLocalReplicator(long db, @NonNull C4Database otherLocalDB, int push, int pull, @Nullable byte[] options, @Nullable C4ReplicatorListener listener, @Nullable C4ReplicationFilter pushFilter, @Nullable C4ReplicationFilter pullFilter, @NonNull AbstractReplicator replicatorContext) throws LiteCoreException {
        C4Replicator replicator;
        Object object = CLASS_LOCK;
        synchronized (object) {
            replicator = new C4Replicator(db, otherLocalDB.getHandle(), push, pull, options, listener, pushFilter, pullFilter, replicatorContext);
            C4Replicator.bind(replicator);
        }
        return replicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    static C4Replicator createTargetReplicator(long db, @NonNull C4Socket openSocket, int push, int pull, @Nullable byte[] options, @Nullable C4ReplicatorListener listener, @NonNull Object replicatorContext) throws LiteCoreException {
        C4Replicator replicator;
        Object object = CLASS_LOCK;
        synchronized (object) {
            replicator = new C4Replicator(db, openSocket.getPeerHandle(), push, pull, options, listener, replicatorContext);
            C4Replicator.bind(replicator);
        }
        return replicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static C4Replicator getReplicatorForHandle(long peer) {
        Object object = CLASS_LOCK;
        synchronized (object) {
            return REVERSE_LOOKUP_TABLE.get(peer);
        }
    }

    @GuardedBy(value="CLASS_LOCK")
    private static void bind(@NonNull C4Replicator repl) {
        Preconditions.assertNotNull(repl, "repl");
        long peer = repl.getPeer();
        Log.d(LogDomain.REPLICATOR, "Binding native replicator @0x%x  => %s", peer, ClassUtils.objId(repl));
        REVERSE_LOOKUP_TABLE.put(peer, repl);
    }

    C4Replicator(long db, @Nullable String schema, @Nullable String host, int port, @Nullable String path, @Nullable String remoteDatabaseName, int push, int pull, @Nullable byte[] options, @Nullable C4ReplicatorListener listener, @Nullable C4ReplicationFilter pushFilter, @Nullable C4ReplicationFilter pullFilter, @NonNull AbstractReplicator replicatorContext, @Nullable SocketFactory socketFactoryContext, int framing) throws LiteCoreException {
        super(C4Replicator.create(db, schema, host, port, path, remoteDatabaseName, push, pull, socketFactoryContext, framing, replicatorContext, pushFilter, pullFilter, options));
        this.listener = listener;
        this.replicatorContext = replicatorContext;
        this.socketFactoryContext = socketFactoryContext;
        this.pushFilter = pushFilter;
        this.pullFilter = pullFilter;
    }

    private C4Replicator(long db, long targetDb, int push, int pull, @Nullable byte[] options, @Nullable C4ReplicatorListener listener, @Nullable C4ReplicationFilter pushFilter, @Nullable C4ReplicationFilter pullFilter, @NonNull AbstractReplicator replicatorContext) throws LiteCoreException {
        super(C4Replicator.createLocal(db, targetDb, push, pull, 1, replicatorContext, pushFilter, pullFilter, options));
        this.socketFactoryContext = null;
        this.listener = listener;
        this.replicatorContext = replicatorContext;
        this.pushFilter = pushFilter;
        this.pullFilter = pullFilter;
    }

    private C4Replicator(long db, long socket, int push, int pull, @Nullable byte[] options, @Nullable C4ReplicatorListener listener, @NonNull Object replicatorContext) throws LiteCoreException {
        super(C4Replicator.createWithSocket(db, socket, push, pull, replicatorContext, options));
        this.socketFactoryContext = null;
        this.listener = listener;
        this.replicatorContext = replicatorContext;
        this.pushFilter = null;
        this.pullFilter = null;
    }

    public void start(boolean restart) {
        C4Replicator.start(this.getPeer(), restart);
    }

    public void stop() {
        C4Replicator.stop(this.getPeer());
    }

    @Override
    @CallSuper
    public void close() {
        REVERSE_LOOKUP_TABLE.remove(this.getPeerUnchecked());
        this.closePeer(null);
    }

    public void setOptions(@Nullable byte[] options) {
        C4Replicator.setOptions(this.getPeer(), options);
    }

    @Nullable
    public C4ReplicatorStatus getStatus() {
        return C4Replicator.getStatus(this.getPeer());
    }

    public boolean isDocumentPending(String docId) throws LiteCoreException {
        return C4Replicator.isDocumentPending(this.getPeer(), docId);
    }

    @NonNull
    public Set<String> getPendingDocIDs() throws LiteCoreException {
        try (FLSliceResult result = FLSliceResult.getManagedSliceResult(C4Replicator.getPendingDocIds(this.getPeer()));){
            FLValue slice = FLValue.fromData(result);
            HashSet<String> hashSet = slice == null ? Collections.emptySet() : new HashSet<String>(slice.asTypedArray());
            return hashSet;
        }
    }

    public void setProgressLevel(int level) throws LiteCoreException {
        C4Replicator.setProgressLevel(this.getPeer(), level);
    }

    public void setHostReachable(boolean reachable) {
        C4Replicator.setHostReachable(this.getPeer(), reachable);
    }

    @Override
    @NonNull
    public String toString() {
        return "C4Repl{" + ClassUtils.objId(this) + "/" + super.toString() + "'}";
    }

    protected void finalize() throws Throwable {
        try {
            this.closePeer(LogDomain.REPLICATOR);
        }
        finally {
            super.finalize();
        }
    }

    private void closePeer(@Nullable LogDomain domain) {
        this.releasePeer(domain, peer -> {
            C4Replicator.stop(peer);
            C4Replicator.free(peer, this.replicatorContext, this.socketFactoryContext);
        });
    }

    private static native long create(long var0, String var2, String var3, int var4, String var5, String var6, int var7, int var8, Object var9, int var10, Object var11, C4ReplicationFilter var12, C4ReplicationFilter var13, byte[] var14) throws LiteCoreException;

    private static native long createLocal(long var0, long var2, int var4, int var5, int var6, Object var7, C4ReplicationFilter var8, C4ReplicationFilter var9, byte[] var10) throws LiteCoreException;

    private static native long createWithSocket(long var0, long var2, int var4, int var5, Object var6, byte[] var7) throws LiteCoreException;

    private static native void free(long var0, Object var2, Object var3);

    private static native void start(long var0, boolean var2);

    private static native void stop(long var0);

    private static native void setOptions(long var0, byte[] var2);

    @NonNull
    private static native C4ReplicatorStatus getStatus(long var0);

    private static native long getPendingDocIds(long var0) throws LiteCoreException;

    private static native boolean isDocumentPending(long var0, String var2) throws LiteCoreException;

    private static native void setProgressLevel(long var0, int var2) throws LiteCoreException;

    private static native void setHostReachable(long var0, boolean var2);
}

