/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.SocketFactory;
import com.couchbase.lite.internal.core.C4NativePeer;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class C4Socket
extends C4NativePeer {
    private static final LogDomain LOG_DOMAIN = LogDomain.NETWORK;
    public static final int WEB_SOCKET_CLIENT_FRAMING = 0;
    public static final int NO_FRAMING = 1;
    public static final int WEB_SOCKET_SERVER_FRAMING = 2;
    private static final Map<Long, C4Socket> HANDLES_TO_SOCKETS = Collections.synchronizedMap(new HashMap());
    @GuardedBy(value="getPeerLock()")
    private boolean closing;

    static void open(long peer, @Nullable Object factory, @Nullable String scheme, @Nullable String hostname, int port, @Nullable String path, @NonNull byte[] options) {
        C4Socket socket = C4Socket.getSocketForPeer(peer);
        Log.d(LOG_DOMAIN, "C4Socket.open @%x: %s, %s", peer, socket, factory);
        if (socket == null) {
            if (!(factory instanceof SocketFactory)) {
                throw new IllegalArgumentException("Context is not a socket factory: " + factory);
            }
            socket = ((SocketFactory)factory).createSocket(peer, Preconditions.assertNotNull(scheme, "scheme"), Preconditions.assertNotNull(hostname, "hostname"), port, Preconditions.assertNotNull(path, "path"), options);
        }
        Preconditions.assertNotNull(socket, "socket").openSocket();
    }

    static void write(long peer, @Nullable byte[] allocatedData) {
        if (allocatedData == null) {
            Log.d(LOG_DOMAIN, "C4Socket.write: allocatedData is null");
            return;
        }
        C4Socket socket = C4Socket.getSocketForPeer(peer);
        Log.d(LOG_DOMAIN, "C4Socket.write(%d) @%x: %s", allocatedData.length, peer, socket);
        if (socket == null) {
            Log.w(LogDomain.NETWORK, "No socket for peer @%x! Packet(%d) dropped!", peer, allocatedData.length);
            return;
        }
        socket.send(allocatedData);
    }

    static void completedReceive(long peer, long byteCount) {
        C4Socket socket = C4Socket.getSocketForPeer(peer);
        Log.d(LOG_DOMAIN, "C4Socket.completedReceive(%d) @%x: %s", byteCount, peer, socket);
        if (socket == null) {
            Log.w(LogDomain.NETWORK, "No socket for peer @%x! Receipt dropped!", peer);
            return;
        }
        socket.completedReceive(byteCount);
    }

    static void requestClose(long peer, int status, @Nullable String message) {
        C4Socket socket = C4Socket.getSocketForPeer(peer);
        Log.d(LOG_DOMAIN, "C4Socket.requestClose(%d) @%x: %s, '%s'", status, peer, socket, message);
        if (socket == null) {
            Log.w(LogDomain.NETWORK, "No socket for peer @%x! Close request dropped!", peer);
            return;
        }
        socket.requestClose(status, message);
    }

    static void close(long peer) {
        C4Socket socket = C4Socket.getSocketForPeer(peer);
        Log.d(LOG_DOMAIN, "C4Socket.close @%x: %s", peer, socket);
        if (socket == null) {
            Log.w(LogDomain.NETWORK, "No socket for peer @%x! Close dropped!", peer);
            return;
        }
        socket.closeSocket();
    }

    static void dispose(long peer) {
        C4Socket.unbindSocket(peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bindSocket(@NonNull C4Socket socket) {
        int n;
        long peer;
        Map<Long, C4Socket> map = HANDLES_TO_SOCKETS;
        synchronized (map) {
            peer = socket.getPeer();
            HANDLES_TO_SOCKETS.put(peer, socket);
            n = HANDLES_TO_SOCKETS.size();
        }
        Log.d(LOG_DOMAIN, "Bind socket(%d) %s to @%x", n, socket, peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static C4Socket getSocketForPeer(long peer) {
        Map<Long, C4Socket> map = HANDLES_TO_SOCKETS;
        synchronized (map) {
            return HANDLES_TO_SOCKETS.get(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unbindSocket(long peer) {
        int n;
        C4Socket socket;
        Map<Long, C4Socket> map = HANDLES_TO_SOCKETS;
        synchronized (map) {
            socket = HANDLES_TO_SOCKETS.remove(peer);
            if (socket != null) {
                socket.releasePeer();
            }
            n = HANDLES_TO_SOCKETS.size();
        }
        Log.d(LOG_DOMAIN, "Unbind socket(%d) %s from @%x", n, socket, peer);
    }

    protected C4Socket(long peer) {
        super(peer);
        C4Socket.bindSocket(this);
    }

    protected C4Socket(@NonNull String schema, @NonNull String host, int port, @NonNull String path, int framing) {
        this.setPeer(C4Socket.fromNative(this, schema, host, port, path, framing));
        C4Socket.bindSocket(this);
    }

    protected abstract void openSocket();

    protected abstract void send(@NonNull byte[] var1);

    protected abstract void completedReceive(long var1);

    protected abstract void requestClose(int var1, @Nullable String var2);

    protected abstract void closeSocket();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void opened() {
        long peer;
        Object object = this.getPeerLock();
        synchronized (object) {
            peer = this.getPeerUnchecked();
            if (peer != 0L) {
                C4Socket.opened(peer);
            }
        }
        Log.d(LOG_DOMAIN, "C4Socket.opened @%x: %s", peer, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void gotHTTPResponse(int httpStatus, @Nullable byte[] responseHeadersFleece) {
        long peer;
        Object object = this.getPeerLock();
        synchronized (object) {
            peer = this.getPeerUnchecked();
            if (peer != 0L) {
                C4Socket.gotHTTPResponse(peer, httpStatus, responseHeadersFleece);
            }
        }
        Log.d(LOG_DOMAIN, "C4Socket.gotHTTPResponse(%d) @%x: %s", httpStatus, peer, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void completedWrite(long byteCount) {
        long peer;
        Object object = this.getPeerLock();
        synchronized (object) {
            peer = this.getPeerUnchecked();
            if (peer != 0L) {
                C4Socket.completedWrite(peer, byteCount);
            }
        }
        Log.d(LOG_DOMAIN, "C4Socket.completedWrite(%d) @%x: %s", byteCount, peer, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void received(@NonNull byte[] data) {
        long peer;
        Object object = this.getPeerLock();
        synchronized (object) {
            peer = this.getPeerUnchecked();
            if (peer != 0L) {
                C4Socket.received(peer, data);
            }
        }
        Log.d(LOG_DOMAIN, "C4Socket.received(%d) @%x: %s", data.length, peer, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void closeRequested(int status, String message) {
        long peer;
        Object object = this.getPeerLock();
        synchronized (object) {
            peer = this.getPeerUnchecked();
            if (peer != 0L) {
                C4Socket.closeRequested(peer, status, message);
            }
        }
        Log.d(LOG_DOMAIN, "C4Socket.closeRequested(%d) @%x: %s, '%s'", status, peer, this, message);
    }

    protected final void closed(int errorDomain, int errorCode, String message) {
        this.closeInternal(errorDomain, errorCode, message);
    }

    @GuardedBy(value="getPeerLock()")
    protected final boolean isC4SocketClosing() {
        return this.closing || this.getPeerUnchecked() == 0L;
    }

    final long getPeerHandle() {
        return this.getPeer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal(int domain, int code, String msg) {
        long peer;
        Object object = this.getPeerLock();
        synchronized (object) {
            peer = this.getPeerUnchecked();
            if (!this.closing && peer != 0L) {
                C4Socket.closed(peer, domain, code, msg);
            }
            this.closing = true;
        }
        Log.d(LOG_DOMAIN, "C4Socket.closed(%d,%d) @%x: %s, '%s'", domain, code, peer, this, msg);
    }

    private static native long fromNative(C4Socket var0, String var1, String var2, int var3, String var4, int var5);

    private static native void opened(long var0);

    private static native void gotHTTPResponse(long var0, int var2, @Nullable byte[] var3);

    private static native void completedWrite(long var0, long var2);

    private static native void received(long var0, byte[] var2);

    private static native void closeRequested(long var0, int var2, String var3);

    private static native void closed(long var0, int var2, int var3, String var4);
}

