/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.core;

import android.support.annotation.NonNull;
import com.couchbase.lite.internal.core.C4;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;

public final class CBLVersion {
    private static final String USER_AGENT_TMPLT = "CouchbaseLite/3.0.0-189 (%s) %s";
    private static final String VERSION_INFO_TMPLT = "CouchbaseLite Java v3.0.0-189 (%s) %s";
    private static final String LIB_INFO_TMPLT = "CE/release Build/189 Commit/4769f18387@57c3573739e0 Core/%s";
    private static final String SYS_INFO_TMPLT = "Java; %s";
    private static final AtomicReference<String> USER_AGENT = new AtomicReference();
    private static final AtomicReference<String> VERSION_INFO = new AtomicReference();
    private static final AtomicReference<String> LIB_INFO = new AtomicReference();
    private static final AtomicReference<String> SYS_INFO = new AtomicReference();

    private CBLVersion() {
    }

    @NonNull
    public static String getUserAgent() {
        String agent = USER_AGENT.get();
        if (agent == null) {
            agent = String.format(Locale.ENGLISH, USER_AGENT_TMPLT, CBLVersion.getSysInfo(), CBLVersion.getLibInfo());
            USER_AGENT.compareAndSet(null, agent);
        }
        return agent;
    }

    @NonNull
    public static String getVersionInfo() {
        String info = VERSION_INFO.get();
        if (info == null) {
            info = String.format(Locale.ENGLISH, VERSION_INFO_TMPLT, CBLVersion.getLibInfo(), CBLVersion.getSysInfo());
            VERSION_INFO.compareAndSet(null, info);
        }
        return info;
    }

    @NonNull
    public static String getLibInfo() {
        String info = LIB_INFO.get();
        if (info == null) {
            info = String.format(Locale.ENGLISH, LIB_INFO_TMPLT, C4.getVersion());
            LIB_INFO.compareAndSet(null, info);
        }
        return info;
    }

    @NonNull
    public static String getSysInfo() {
        String info = SYS_INFO.get();
        if (info == null) {
            info = String.format(Locale.ENGLISH, SYS_INFO_TMPLT, System.getProperty("os.name", "unknown"));
            SYS_INFO.compareAndSet(null, info);
        }
        return info;
    }
}

