/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal.fleece;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.internal.fleece.FLArray;
import com.couchbase.lite.internal.fleece.FLDict;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.List;
import java.util.Map;

public class FLValue {
    private final long handle;

    @Nullable
    public static FLValue fromData(@Nullable FLSliceResult slice) {
        if (slice == null) {
            return null;
        }
        long value = FLValue.fromData(slice.getHandle());
        return value == 0L ? null : new FLValue(value);
    }

    @Nullable
    public static String getJSONForJSON5(@Nullable String json5) throws LiteCoreException {
        return FLValue.json5toJson(json5);
    }

    @NonNull
    public static FLValue fromData(@NonNull byte[] data) {
        return new FLValue(FLValue.fromTrustedData(data));
    }

    @Nullable
    public static Object toObject(@NonNull FLValue flValue) {
        return flValue.asObject();
    }

    public FLValue(long handle) {
        Preconditions.assertNotZero(handle, "handle");
        this.handle = handle;
    }

    public int getType() {
        return FLValue.getType(this.handle);
    }

    public boolean isNumber() {
        return this.getType() == 2;
    }

    public boolean isInteger() {
        return FLValue.isInteger(this.handle);
    }

    public boolean isUnsigned() {
        return FLValue.isUnsigned(this.handle);
    }

    public boolean isDouble() {
        return FLValue.isDouble(this.handle);
    }

    @Nullable
    public String toStr() {
        return FLValue.toString(this.handle);
    }

    @Nullable
    public String toJSON() {
        return FLValue.toJSON(this.handle);
    }

    @Nullable
    public String toJSON5() {
        return FLValue.toJSON5(this.handle);
    }

    @NonNull
    public byte[] asData() {
        return FLValue.asData(this.handle);
    }

    public boolean asBool() {
        return FLValue.asBool(this.handle);
    }

    public long asInt() {
        return FLValue.asInt(this.handle);
    }

    public long asUnsigned() {
        return FLValue.asUnsigned(this.handle);
    }

    public float asFloat() {
        return FLValue.asFloat(this.handle);
    }

    public double asDouble() {
        return FLValue.asDouble(this.handle);
    }

    @NonNull
    public String asString() {
        return FLValue.asString(this.handle);
    }

    @NonNull
    public List<Object> asArray() {
        return this.asFLArray().asArray();
    }

    @NonNull
    public <T> List<T> asTypedArray() {
        return this.asFLArray().asTypedArray();
    }

    @NonNull
    public FLDict asFLDict() {
        return new FLDict(FLValue.asDict(this.handle));
    }

    @NonNull
    public Map<String, Object> asDict() {
        return this.asFLDict().asDict();
    }

    @Nullable
    public Object asObject() {
        switch (FLValue.getType(this.handle)) {
            case 1: {
                return this.asBool();
            }
            case 2: {
                if (this.isInteger()) {
                    return this.isUnsigned() ? Long.valueOf(this.asUnsigned()) : Long.valueOf(this.asInt());
                }
                if (this.isDouble()) {
                    return this.asDouble();
                }
                return Float.valueOf(this.asFloat());
            }
            case 3: {
                return this.asString();
            }
            case 4: {
                return this.asData();
            }
            case 5: {
                return this.asArray();
            }
            case 6: {
                return this.asDict();
            }
        }
        return null;
    }

    @Nullable
    <T> T withContent(@NonNull Fn.Function<Long, T> fn) {
        return fn.apply(this.handle);
    }

    @NonNull
    FLArray asFLArray() {
        return new FLArray(FLValue.asArray(this.handle));
    }

    private static native long fromTrustedData(byte[] var0);

    private static native long fromData(long var0);

    private static native int getType(long var0);

    private static native boolean isInteger(long var0);

    private static native boolean isUnsigned(long var0);

    private static native boolean isDouble(long var0);

    @Nullable
    private static native String toString(long var0);

    @Nullable
    private static native String toJSON(long var0);

    @Nullable
    private static native String toJSON5(long var0);

    @NonNull
    private static native byte[] asData(long var0);

    private static native boolean asBool(long var0);

    private static native long asUnsigned(long var0);

    private static native long asInt(long var0);

    private static native float asFloat(long var0);

    private static native double asDouble(long var0);

    @NonNull
    private static native String asString(long var0);

    private static native long asArray(long var0);

    private static native long asDict(long var0);

    @Nullable
    private static native String json5toJson(@Nullable String var0) throws LiteCoreException;
}

