//
// Copyright (c) 2020 Couchbase, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
package com.couchbase.lite;

import androidx.annotation.Nullable;

import com.couchbase.lite.internal.DbContext;
import com.couchbase.lite.internal.core.C4Document;


class DocContext extends DbContext {
    @Nullable
    private final C4Document c4Document;

    DocContext(@Nullable Database db, @Nullable C4Document c4Doc) {
        super(db);
        this.c4Document = c4Doc;
    }

    @Nullable
    C4Document getDocument() { return c4Document; }
}
