//
// Copyright (c) 2022 Couchbase, Inc All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package com.couchbase.lite.internal.core;

import androidx.annotation.NonNull;


public final class C4CollectionSpec {
    @NonNull
    private final String scopeName;
    @NonNull
    private final String collectionName;

    public C4CollectionSpec(@NonNull String scopeName, @NonNull String collectionName) {
        this.scopeName = scopeName;
        this.collectionName = collectionName;
    }

    @NonNull
    public String getScopeName() { return scopeName; }
    @NonNull
    public String getCollectionName() { return collectionName; }
}
