/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.DatabaseConfiguration;
import com.couchbase.lite.internal.BaseImmutableDatabaseConfiguration;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.utils.FileUtils;
import com.couchbase.lite.internal.utils.Preconditions;

abstract class AbstractDatabaseConfiguration {
    private String dbDirectory;
    private boolean fullSync;

    protected AbstractDatabaseConfiguration() {
        this(null, false);
    }

    protected AbstractDatabaseConfiguration(@Nullable AbstractDatabaseConfiguration config) {
        this(config == null ? null : config.getDirectory(), config == null ? false : config.isFullSync());
    }

    protected AbstractDatabaseConfiguration(@NonNull BaseImmutableDatabaseConfiguration config) {
        this(config.getDirectory(), config.isFullSync());
    }

    private AbstractDatabaseConfiguration(@Nullable String dbDir, boolean fullSync) {
        CouchbaseLiteInternal.requireInit("Cannot create database configuration");
        this.dbDirectory = dbDir != null ? dbDir : CouchbaseLiteInternal.getDefaultDbDirPath();
        this.fullSync = fullSync;
    }

    @NonNull
    public DatabaseConfiguration setDirectory(@NonNull String directory) {
        Preconditions.assertNotNull(directory, "directory");
        this.dbDirectory = FileUtils.verifyDir(directory).getAbsolutePath();
        return this.getDatabaseConfiguration();
    }

    @NonNull
    public String getDirectory() {
        return this.dbDirectory;
    }

    @NonNull
    public DatabaseConfiguration setFullSync(boolean isfullSync) {
        this.fullSync = isfullSync;
        return this.getDatabaseConfiguration();
    }

    public boolean isFullSync() {
        return this.fullSync;
    }

    @NonNull
    protected abstract DatabaseConfiguration getDatabaseConfiguration();
}

