/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.Expression;
import com.couchbase.lite.internal.utils.Preconditions;

abstract class AbstractFunction {
    AbstractFunction() {
    }

    @NonNull
    public static Expression avg(@NonNull Expression operand) {
        return AbstractFunction.sexpr("AVG()", operand);
    }

    @NonNull
    public static Expression count(@Nullable Expression operand) {
        return AbstractFunction.sexpr("COUNT()", operand != null ? operand : Expression.value("."));
    }

    @NonNull
    public static Expression min(@NonNull Expression operand) {
        return AbstractFunction.sexpr("MIN()", operand);
    }

    @NonNull
    public static Expression max(@NonNull Expression operand) {
        return AbstractFunction.sexpr("MAX()", operand);
    }

    @NonNull
    public static Expression sum(@NonNull Expression operand) {
        return AbstractFunction.sexpr("SUM()", operand);
    }

    @NonNull
    public static Expression abs(@NonNull Expression operand) {
        return AbstractFunction.sexpr("ABS()", operand);
    }

    @NonNull
    public static Expression acos(@NonNull Expression operand) {
        return AbstractFunction.sexpr("ACOS()", operand);
    }

    @NonNull
    public static Expression asin(@NonNull Expression operand) {
        return AbstractFunction.sexpr("ASIN()", operand);
    }

    @NonNull
    public static Expression atan(@NonNull Expression operand) {
        return AbstractFunction.sexpr("ATAN()", operand);
    }

    @NonNull
    public static Expression atan2(@NonNull Expression y, @NonNull Expression x) {
        return AbstractFunction.expr("ATAN2()", Preconditions.assertNotNull(y, "y"), Preconditions.assertNotNull(x, "x"));
    }

    @NonNull
    public static Expression ceil(@NonNull Expression operand) {
        return AbstractFunction.sexpr("CEIL()", operand);
    }

    @NonNull
    public static Expression cos(@NonNull Expression operand) {
        return AbstractFunction.sexpr("COS()", operand);
    }

    @NonNull
    public static Expression degrees(@NonNull Expression operand) {
        return AbstractFunction.sexpr("DEGREES()", operand);
    }

    @NonNull
    public static Expression e() {
        return AbstractFunction.expr("E()", new Expression[]{null});
    }

    @NonNull
    public static Expression exp(@NonNull Expression operand) {
        return AbstractFunction.sexpr("EXP()", operand);
    }

    @NonNull
    public static Expression floor(@NonNull Expression operand) {
        return AbstractFunction.sexpr("FLOOR()", operand);
    }

    @NonNull
    public static Expression ln(@NonNull Expression operand) {
        return AbstractFunction.sexpr("LN()", operand);
    }

    @NonNull
    public static Expression log(@NonNull Expression operand) {
        return AbstractFunction.sexpr("LOG()", operand);
    }

    @NonNull
    public static Expression pi() {
        return AbstractFunction.expr("PI()", new Expression[]{null});
    }

    @NonNull
    public static Expression power(@NonNull Expression base, @NonNull Expression exp) {
        return AbstractFunction.expr("POWER()", Preconditions.assertNotNull(base, "base"), Preconditions.assertNotNull(exp, "exponent"));
    }

    @NonNull
    public static Expression radians(@NonNull Expression operand) {
        return AbstractFunction.sexpr("RADIANS()", operand);
    }

    @NonNull
    public static Expression round(@NonNull Expression operand) {
        return AbstractFunction.sexpr("ROUND()", operand);
    }

    @NonNull
    public static Expression round(@NonNull Expression operand, @NonNull Expression digits) {
        return AbstractFunction.expr("ROUND()", Preconditions.assertNotNull(operand, "operand"), Preconditions.assertNotNull(digits, "digits"));
    }

    @NonNull
    public static Expression sign(@NonNull Expression operand) {
        return AbstractFunction.sexpr("SIGN()", operand);
    }

    @NonNull
    public static Expression sin(@NonNull Expression operand) {
        return AbstractFunction.sexpr("SIN()", operand);
    }

    @NonNull
    public static Expression sqrt(@NonNull Expression operand) {
        return AbstractFunction.sexpr("SQRT()", operand);
    }

    @NonNull
    public static Expression tan(@NonNull Expression operand) {
        return AbstractFunction.sexpr("TAN()", operand);
    }

    @NonNull
    public static Expression trunc(@NonNull Expression operand) {
        return AbstractFunction.sexpr("TRUNC()", operand);
    }

    @NonNull
    public static Expression trunc(@NonNull Expression operand, @NonNull Expression digits) {
        return AbstractFunction.expr("TRUNC()", Preconditions.assertNotNull(operand, "operand"), Preconditions.assertNotNull(digits, "digits"));
    }

    @NonNull
    public static Expression contains(@NonNull Expression operand, @NonNull Expression substring) {
        return AbstractFunction.expr("CONTAINS()", Preconditions.assertNotNull(operand, "operand"), Preconditions.assertNotNull(substring, "substring"));
    }

    @NonNull
    public static Expression length(@NonNull Expression operand) {
        return AbstractFunction.sexpr("LENGTH()", operand);
    }

    @NonNull
    public static Expression lower(@NonNull Expression operand) {
        return AbstractFunction.sexpr("LOWER()", operand);
    }

    @NonNull
    public static Expression ltrim(@NonNull Expression operand) {
        return AbstractFunction.sexpr("LTRIM()", operand);
    }

    @NonNull
    public static Expression rtrim(@NonNull Expression operand) {
        return AbstractFunction.sexpr("RTRIM()", operand);
    }

    @NonNull
    public static Expression trim(@NonNull Expression operand) {
        return AbstractFunction.sexpr("TRIM()", operand);
    }

    @NonNull
    public static Expression upper(@NonNull Expression operand) {
        return AbstractFunction.sexpr("UPPER()", operand);
    }

    @NonNull
    public static Expression millisToString(@NonNull Expression operand) {
        return AbstractFunction.sexpr("MILLIS_TO_STR()", operand);
    }

    @NonNull
    public static Expression millisToUTC(@NonNull Expression operand) {
        return AbstractFunction.sexpr("MILLIS_TO_UTC()", operand);
    }

    @NonNull
    public static Expression stringToMillis(@NonNull Expression operand) {
        return AbstractFunction.sexpr("STR_TO_MILLIS()", operand);
    }

    @NonNull
    public static Expression stringToUTC(@NonNull Expression operand) {
        return AbstractFunction.sexpr("STR_TO_UTC()", operand);
    }

    @NonNull
    private static Expression.FunctionExpression sexpr(@NonNull String expr, @NonNull Expression operand) {
        return new Expression.FunctionExpression(expr, Preconditions.assertNotNull(operand, "operand expression"));
    }

    @NonNull
    private static Expression.FunctionExpression expr(@NonNull String expr, Expression ... operands) {
        return new Expression.FunctionExpression(expr, operands);
    }
}

