/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.AbstractDatabase;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.Parameters;
import com.couchbase.lite.Query;
import com.couchbase.lite.QueryChange;
import com.couchbase.lite.QueryChangeListener;
import com.couchbase.lite.ResultSet;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.core.C4Query;
import com.couchbase.lite.internal.core.C4QueryEnumerator;
import com.couchbase.lite.internal.core.C4QueryObserver;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import com.couchbase.lite.internal.listener.ChangeListenerToken;
import com.couchbase.lite.internal.listener.Listenable;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;

abstract class AbstractQuery
implements Listenable<QueryChange, QueryChangeListener>,
Query {
    protected static final LogDomain DOMAIN = LogDomain.QUERY;
    private final LiveQueries liveQueries = new LiveQueries(this::registerLiveQuery, this::unregisterLiveQuery);
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private Map<String, Integer> columnNames;
    @GuardedBy(value="lock")
    private C4Query c4query;
    @Nullable
    private Parameters parameters;

    AbstractQuery() {
    }

    @Override
    @Nullable
    public Parameters getParameters() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameters(@Nullable Parameters parameters) throws CouchbaseLiteException {
        Object object = this.lock;
        synchronized (object) {
            if (parameters != null) {
                parameters = parameters.readonlyCopy();
            }
            this.parameters = parameters;
            if (parameters == null) {
                return;
            }
            try {
                this.getC4QueryLocked().setParameters(parameters.encode());
            }
            catch (LiteCoreException e) {
                throw CouchbaseLiteException.convertException(e, "Failed encoding parameters");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public ResultSet execute() throws CouchbaseLiteException {
        try {
            Map<String, Integer> colNames;
            C4QueryEnumerator c4enum;
            if (this.parameters == null) {
                this.parameters = new Parameters();
            }
            FLSliceResult params = this.parameters.encode();
            Object object = this.getDbLock();
            synchronized (object) {
                Object object2 = this.lock;
                synchronized (object2) {
                    c4enum = this.getC4QueryLocked().run(params);
                    colNames = this.columnNames;
                }
            }
            return new ResultSet(this, c4enum, new HashMap<String, Integer>(colNames));
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public String explain() throws CouchbaseLiteException {
        Object object = this.getDbLock();
        synchronized (object) {
            Object object2 = this.lock;
            synchronized (object2) {
                String exp = this.getC4QueryLocked().explain();
                if (exp == null) {
                    throw new CouchbaseLiteException("Could not explain query");
                }
                return exp;
            }
        }
    }

    @Override
    @NonNull
    public ListenerToken addChangeListener(@NonNull QueryChangeListener listener) {
        return this.addChangeListener((Executor)null, listener);
    }

    @Override
    @NonNull
    public ListenerToken addChangeListener(@Nullable Executor executor, @NonNull QueryChangeListener listener) {
        Preconditions.assertNotNull(listener, "listener");
        ChangeListenerToken<QueryChange> token = new ChangeListenerToken<QueryChange>(listener, executor, this::removeListener);
        this.liveQueries.put(token, this.getObserver(token));
        (executor != null ? executor : CouchbaseLiteInternal.getExecutionService().getDefaultExecutor()).execute(() -> {
            Object object = this.getDbLock();
            synchronized (object) {
                this.liveQueries.start(token);
            }
        });
        return token;
    }

    @Override
    @Deprecated
    public void removeChangeListener(@NonNull ListenerToken token) {
        this.removeListener(token);
    }

    @Nullable
    protected abstract AbstractDatabase getDatabase();

    @GuardedBy(value="lock")
    @NonNull
    protected abstract C4Query prepQueryLocked(@NonNull AbstractDatabase var1) throws CouchbaseLiteException;

    @VisibleForTesting
    boolean isLive(ListenerToken token) {
        return this.liveQueries.isLive(token);
    }

    @VisibleForTesting
    int liveCount() {
        return this.liveQueries.liveCount();
    }

    @GuardedBy(value="lock")
    @NonNull
    private C4Query getC4QueryLocked() throws CouchbaseLiteException {
        if (this.c4query != null) {
            return this.c4query;
        }
        AbstractDatabase db = this.getDatabase();
        if (db == null) {
            throw new CouchbaseLiteException("Attempt to prep query with no database");
        }
        C4Query c4Q = this.prepQueryLocked(db);
        int nCols = c4Q.getColumnCount();
        HashMap<String, Integer> colNames = new HashMap<String, Integer>();
        for (int i = 0; i < nCols; ++i) {
            String colName = c4Q.getColumnNameForIndex(i);
            if (colName == null) continue;
            if (colNames.containsKey(colName)) {
                throw new CouchbaseLiteException(Log.formatStandardMessage("DuplicateSelectResultName", colName), "CouchbaseLite", 23);
            }
            colNames.put(colName, i);
        }
        this.columnNames = colNames;
        this.c4query = c4Q;
        return this.c4query;
    }

    private void registerLiveQuery() {
        AbstractDatabase db = this.getDatabase();
        if (db == null) {
            return;
        }
        db.registerProcess(new AbstractDatabase.ActiveProcess<AbstractQuery>(this){

            @Override
            public boolean isActive() {
                return AbstractQuery.this.liveQueries.isLive();
            }

            @Override
            public void stop() {
                for (ListenerToken token : AbstractQuery.this.liveQueries.getTokens()) {
                    token.remove();
                }
            }
        });
    }

    private void unregisterLiveQuery() {
        AbstractDatabase db = this.getDatabase();
        if (db != null) {
            db.unregisterProcess(this);
        }
    }

    @NonNull
    private C4QueryObserver getObserver(@NonNull ChangeListenerToken<QueryChange> token) {
        Object object = this.lock;
        synchronized (object) {
            try {
                return C4QueryObserver.create(this.getC4QueryLocked(), (r, err) -> this.onQueryChanged(token, r, err));
            }
            catch (CouchbaseLiteException e) {
                throw new CouchbaseLiteError("Failed creating query listener", e);
            }
        }
    }

    private void removeListener(@NonNull ListenerToken token) {
        Preconditions.assertNotNull(token, "token");
        this.liveQueries.remove(token);
    }

    private void onQueryChanged(@NonNull ChangeListenerToken<QueryChange> token, @Nullable C4QueryEnumerator results, @Nullable LiteCoreException err) {
        token.postChange(new QueryChange(this, new ResultSet(this, results, this.columnNames), err));
    }

    @NonNull
    private Object getDbLock() {
        AbstractDatabase db = this.getDatabase();
        if (db != null) {
            return db.getDbLock();
        }
        throw new CouchbaseLiteError("Cannot seize DB lock");
    }

    private static class LiveQueries {
        private final Map<ListenerToken, C4QueryObserver> liveQueries = new HashMap<ListenerToken, C4QueryObserver>();
        @NonNull
        private final Runnable onFirst;
        @NonNull
        private final Runnable onLast;

        LiveQueries(@NonNull Runnable onFirst, @NonNull Runnable onLast) {
            this.onFirst = onFirst;
            this.onLast = onLast;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(@NonNull ListenerToken token, @NonNull C4QueryObserver observer) {
            Map<ListenerToken, C4QueryObserver> map = this.liveQueries;
            synchronized (map) {
                if (this.liveQueries.isEmpty()) {
                    this.onFirst.run();
                }
                this.liveQueries.put(token, observer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(@NonNull ChangeListenerToken<QueryChange> token) {
            Map<ListenerToken, C4QueryObserver> map = this.liveQueries;
            synchronized (map) {
                C4QueryObserver observer = this.liveQueries.get(token);
                if (observer != null) {
                    observer.enable();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(@NonNull ListenerToken token) {
            Map<ListenerToken, C4QueryObserver> map = this.liveQueries;
            synchronized (map) {
                C4QueryObserver observer = this.liveQueries.remove(token);
                if (observer != null) {
                    observer.close();
                }
                if (this.liveQueries.isEmpty()) {
                    this.onLast.run();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public Set<ListenerToken> getTokens() {
            Map<ListenerToken, C4QueryObserver> map = this.liveQueries;
            synchronized (map) {
                return new HashSet<ListenerToken>(this.liveQueries.keySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isLive() {
            Map<ListenerToken, C4QueryObserver> map = this.liveQueries;
            synchronized (map) {
                return !this.liveQueries.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        public boolean isLive(@NonNull ListenerToken token) {
            Map<ListenerToken, C4QueryObserver> map = this.liveQueries;
            synchronized (map) {
                return this.liveQueries.containsKey(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        public int liveCount() {
            Map<ListenerToken, C4QueryObserver> map = this.liveQueries;
            synchronized (map) {
                return this.liveQueries.size();
            }
        }
    }
}

