/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import com.couchbase.lite.internal.BaseAuthenticator;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class BasicAuthenticator
extends BaseAuthenticator {
    @NonNull
    private final String username;
    @NonNull
    private final char[] password;

    public BasicAuthenticator(@NonNull String username, @NonNull char[] password) {
        this.username = Preconditions.assertNotNull(username, "username");
        Preconditions.assertNotNull(password, "password");
        this.password = new char[password.length];
        System.arraycopy(password, 0, this.password, 0, this.password.length);
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    @Deprecated
    @NonNull
    public String getPassword() {
        return new String(this.password);
    }

    @NonNull
    public char[] getPasswordChars() {
        char[] pwd = new char[this.password.length];
        System.arraycopy(this.password, 0, pwd, 0, pwd.length);
        return pwd;
    }

    protected void finalize() throws Throwable {
        try {
            char[] pwd = this.password;
            if (pwd != null) {
                Arrays.fill(pwd, '\u0000');
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    protected void authenticate(@NonNull Map<String, Object> options) {
        HashMap<String, String> auth = (HashMap<String, String>)options.get("auth");
        if (auth == null) {
            auth = new HashMap<String, String>();
            options.put("auth", auth);
        }
        auth.put("type", "Basic");
        auth.put("username", this.username);
        auth.put("password", (String)this.password);
    }
}

