/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.AbstractDatabase;
import com.couchbase.lite.AbstractQuery;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.DataSource;
import com.couchbase.lite.Expression;
import com.couchbase.lite.GroupBy;
import com.couchbase.lite.Having;
import com.couchbase.lite.Joins;
import com.couchbase.lite.Limit;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.OrderBy;
import com.couchbase.lite.Select;
import com.couchbase.lite.internal.core.C4Query;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.JSONUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;

abstract class BuilderQuery
extends AbstractQuery {
    private Select select;
    private DataSource from;
    private Joins joins;
    private Expression where;
    private GroupBy groupBy;
    private Having having;
    private OrderBy orderBy;
    private Limit limit;

    BuilderQuery() {
    }

    @NonNull
    public String toString() {
        return this.getClass().getSimpleName() + "{" + ClassUtils.objId(this) + ", json=" + this.marshalAsJSONSafely() + "}";
    }

    @Override
    @NonNull
    protected final AbstractDatabase getDatabase() {
        return this.from.getDatabase();
    }

    @Override
    @GuardedBy(value="lock")
    @NonNull
    protected final C4Query prepQueryLocked(@NonNull AbstractDatabase db) throws CouchbaseLiteException {
        String json = this.marshalAsJSONSafely();
        Log.d(DOMAIN, "JSON query: %s", json);
        if (json == null) {
            throw new CouchbaseLiteException("Failed to generate JSON query.");
        }
        try {
            return db.createJsonQuery(json);
        }
        catch (LiteCoreException e) {
            throw CouchbaseLiteException.convertException(e);
        }
    }

    void setSelect(Select select) {
        this.select = select;
    }

    void setFrom(@NonNull DataSource from) {
        this.from = from;
    }

    void setJoins(Joins joins) {
        this.joins = joins;
    }

    void setWhere(Expression where) {
        this.where = where;
    }

    void setGroupBy(GroupBy groupBy) {
        this.groupBy = groupBy;
    }

    void setHaving(Having having) {
        this.having = having;
    }

    void setOrderBy(OrderBy orderBy) {
        this.orderBy = orderBy;
    }

    void setLimit(Limit limit) {
        this.limit = limit;
    }

    void copy(BuilderQuery query) {
        this.select = query.select;
        this.from = query.from;
        this.joins = query.joins;
        this.where = query.where;
        this.groupBy = query.groupBy;
        this.having = query.having;
        this.orderBy = query.orderBy;
        this.limit = query.limit;
        try {
            this.setParameters(query.getParameters());
        }
        catch (CouchbaseLiteException e) {
            throw new IllegalArgumentException("Failed copying query parameters", e);
        }
    }

    @Nullable
    private String marshalAsJSONSafely() {
        try {
            return this.marshalAsJSON();
        }
        catch (JSONException e) {
            Log.w(LogDomain.QUERY, "Failed marshalling query as JSON query", e);
            return null;
        }
    }

    @NonNull
    private String marshalAsJSON() throws JSONException {
        Object havingJson;
        HashMap<String, Object> json = new HashMap<String, Object>();
        if (this.select != null && this.select.isDistinct()) {
            json.put("DISTINCT", "true");
        }
        if (this.select != null && this.select.hasSelectResults()) {
            json.put("WHAT", this.select.asJSON());
        }
        ArrayList<Map<String, Object>> froms = new ArrayList<Map<String, Object>>();
        Map<String, Object> as = this.from.asJSON();
        if (!as.isEmpty()) {
            froms.add(as);
        }
        if (this.joins != null) {
            froms.addAll((List)this.joins.asJSON());
        }
        if (!froms.isEmpty()) {
            json.put("FROM", froms);
        }
        if (this.where != null) {
            json.put("WHERE", this.where.asJSON());
        }
        if (this.groupBy != null) {
            json.put("GROUP_BY", this.groupBy.asJSON());
        }
        if (this.having != null && (havingJson = this.having.asJSON()) != null) {
            json.put("HAVING", havingJson);
        }
        if (this.orderBy != null) {
            json.put("ORDER_BY", this.orderBy.asJSON());
        }
        if (this.limit != null) {
            List limits = (List)this.limit.asJSON();
            json.put("LIMIT", limits.get(0));
            if (limits.size() > 1) {
                json.put("OFFSET", limits.get(1));
            }
        }
        return JSONUtils.toJSON(json).toString();
    }
}

