/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.fleece.MCollection;
import com.couchbase.lite.internal.fleece.MValue;
import com.couchbase.lite.internal.utils.ClassUtils;

final class CBLConverter {
    private CBLConverter() {
    }

    @Nullable
    static Number asNumber(@Nullable Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        return ClassUtils.castOrNull(Number.class, value);
    }

    static boolean asBoolean(@Nullable Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        return true;
    }

    static int asInteger(@NonNull MValue val, @Nullable MCollection container) {
        FLValue value = val.getValue();
        if (value != null) {
            return (int)value.asInt();
        }
        Number num = CBLConverter.asNumber(val.asNative(container));
        return num != null ? num.intValue() : 0;
    }

    static long asLong(@NonNull MValue val, @Nullable MCollection container) {
        FLValue value = val.getValue();
        if (value != null) {
            return value.asInt();
        }
        Number num = CBLConverter.asNumber(val.asNative(container));
        return num != null ? num.longValue() : 0L;
    }

    static float asFloat(@NonNull MValue val, @Nullable MCollection container) {
        FLValue value = val.getValue();
        if (value != null) {
            return value.asFloat();
        }
        Number num = CBLConverter.asNumber(val.asNative(container));
        return num != null ? num.floatValue() : 0.0f;
    }

    static double asDouble(@NonNull MValue val, @Nullable MCollection container) {
        FLValue value = val.getValue();
        if (value != null) {
            return value.asDouble();
        }
        Number num = CBLConverter.asNumber(val.asNative(container));
        return num != null ? num.doubleValue() : 0.0;
    }
}

