/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.ConflictResolver;
import com.couchbase.lite.ReplicationFilter;
import java.util.ArrayList;
import java.util.List;

public class CollectionConfiguration {
    @Nullable
    private List<String> channels;
    @Nullable
    private List<String> documentIDs;
    @Nullable
    private ReplicationFilter pullFilter;
    @Nullable
    private ReplicationFilter pushFilter;
    @Nullable
    private ConflictResolver conflictResolver;

    public CollectionConfiguration() {
    }

    public CollectionConfiguration(@Nullable List<String> channels, @Nullable List<String> documentIDs, @Nullable ReplicationFilter pullFilter, @Nullable ReplicationFilter pushFilter, @Nullable ConflictResolver conflictResolver) {
        this.channels = channels;
        this.documentIDs = documentIDs;
        this.pullFilter = pullFilter;
        this.pushFilter = pushFilter;
        this.conflictResolver = conflictResolver;
    }

    CollectionConfiguration(@NonNull CollectionConfiguration config) {
        this(config.channels, config.documentIDs, config.pullFilter, config.pushFilter, config.conflictResolver);
    }

    @NonNull
    public final CollectionConfiguration setDocumentIDs(@Nullable List<String> documentIDs) {
        this.documentIDs = documentIDs == null ? null : new ArrayList<String>(documentIDs);
        return this;
    }

    @NonNull
    public final CollectionConfiguration setChannels(@Nullable List<String> channels) {
        this.channels = channels == null ? null : new ArrayList<String>(channels);
        return this;
    }

    @NonNull
    public final CollectionConfiguration setConflictResolver(@Nullable ConflictResolver conflictResolver) {
        this.conflictResolver = conflictResolver;
        return this;
    }

    @NonNull
    public final CollectionConfiguration setPullFilter(@Nullable ReplicationFilter pullFilter) {
        this.pullFilter = pullFilter;
        return this;
    }

    @NonNull
    public final CollectionConfiguration setPushFilter(@Nullable ReplicationFilter pushFilter) {
        this.pushFilter = pushFilter;
        return this;
    }

    @Nullable
    public final List<String> getChannels() {
        return this.channels == null ? null : new ArrayList<String>(this.channels);
    }

    @Nullable
    public final List<String> getDocumentIDs() {
        return this.documentIDs == null ? null : new ArrayList<String>(this.documentIDs);
    }

    @Nullable
    public ConflictResolver getConflictResolver() {
        return this.conflictResolver;
    }

    @Nullable
    public ReplicationFilter getPullFilter() {
        return this.pullFilter;
    }

    @Nullable
    public ReplicationFilter getPushFilter() {
        return this.pushFilter;
    }

    @NonNull
    public String toString() {
        return "CollectionConfiguration{(" + (this.pullFilter != null ? "<" : "") + (this.conflictResolver != null ? "!" : "") + (this.pushFilter != null ? ">" : "") + "): " + this.channels + ", " + this.documentIDs + "}";
    }
}

