/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.AbstractConsoleLogger;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.core.C4Log;
import java.io.PrintStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;

public class ConsoleLogger
extends AbstractConsoleLogger {
    private static final String LOG_TAG = "/CouchbaseLite/";
    private static final int THREAD_FIELD_LEN = 7;
    private static final String THREAD_FIELD_PAD = String.join((CharSequence)"", Collections.nCopies(7, " "));
    private static final ThreadLocal<DateTimeFormatter> TS_FORMAT = ThreadLocal.withInitial(() -> DateTimeFormatter.ofPattern("MM-dd HH:mm:ss.SSS"));

    @NonNull
    public static PrintStream getLogStream(@NonNull LogLevel level) {
        return CouchbaseLiteInternal.debugging() || LogLevel.WARNING.compareTo(level) > 0 ? System.out : System.err;
    }

    @NonNull
    public static String formatLog(@NonNull LogLevel level, @NonNull String domain, @NonNull String message) {
        String tf = THREAD_FIELD_PAD + Thread.currentThread().getId();
        return TS_FORMAT.get().format(LocalDateTime.now()) + tf.substring(tf.length() - 7) + " " + (Object)((Object)level) + LOG_TAG + domain + ": " + message;
    }

    ConsoleLogger(@Nullable C4Log c4Log) {
        super(c4Log);
    }

    @Override
    public void log(@NonNull LogLevel level, @NonNull LogDomain domain, @NonNull String message) {
        super.log(level, domain, message);
    }

    @Override
    protected void doLog(@NonNull LogLevel level, @NonNull LogDomain domain, @NonNull String message) {
        ConsoleLogger.getLogStream(level).println(ConsoleLogger.formatLog(level, domain.name(), message));
    }
}

