/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.core.C4;
import com.couchbase.lite.internal.core.CBLVersion;
import com.couchbase.lite.internal.logging.Log;
import java.util.Map;

public final class CouchbaseLiteException
extends Exception {
    private final int code;
    @NonNull
    private final String domain;
    @Nullable
    private final Map<String, Object> info;

    @NonNull
    public static CouchbaseLiteException convertException(@Nullable LiteCoreException e) {
        return e == null ? new CouchbaseLiteException("Unknown LiteCore exception") : CouchbaseLiteException.toCouchbaseLiteException(e.domain, e.code, null, e);
    }

    @NonNull
    public static CouchbaseLiteException convertException(@Nullable LiteCoreException e, @NonNull String msg) {
        return e == null ? new CouchbaseLiteException(msg) : CouchbaseLiteException.toCouchbaseLiteException(e.domain, e.code, msg, e);
    }

    @NonNull
    public static CouchbaseLiteException toCouchbaseLiteException(int domain, int status, int info) {
        return domain == 0 || status == 0 ? CouchbaseLiteException.toCouchbaseLiteException(domain, status, null, null) : CouchbaseLiteException.toCouchbaseLiteException(domain, status, C4.getMessage(domain, status, info), null);
    }

    @NonNull
    public static CouchbaseLiteException toCouchbaseLiteException(int domainCode, int statusCode, @Nullable String msg, @Nullable Exception e) {
        if (e instanceof LiteCoreException) {
            Log.w(LogDomain.DATABASE, "Lite Core exception", e);
        }
        int code = statusCode;
        String domain = "CouchbaseLite";
        switch (domainCode) {
            case 1: {
                break;
            }
            case 2: {
                domain = "POSIXErrorDomain";
                break;
            }
            case 3: {
                domain = "CouchbaseLite.SQLite";
                break;
            }
            case 4: {
                domain = "CouchbaseLite.Fleece";
                break;
            }
            case 5: {
                code += 5000;
                break;
            }
            case 6: {
                code += 10000;
                break;
            }
            default: {
                Log.w(LogDomain.DATABASE, "Unable to map C4Error(%d,%d) to an CouchbaseLiteException", domainCode, statusCode);
            }
        }
        return new CouchbaseLiteException(msg, e, domain, code, null);
    }

    static boolean isConflict(@Nullable CouchbaseLiteException err) {
        return err != null && "CouchbaseLite".equals(err.getDomain()) && 8 == err.getCode();
    }

    @NonNull
    static String getErrorMessage(@Nullable String msg, @Nullable Exception e) {
        String errMsg = msg;
        if (msg == null && e != null) {
            errMsg = e.getMessage();
        }
        return Log.lookupStandardMessage(errMsg);
    }

    public CouchbaseLiteException(@NonNull String message) {
        this(message, null, null, 0, null);
    }

    @Deprecated
    public CouchbaseLiteException(@NonNull Exception cause) {
        this(null, cause, null, 0, null);
    }

    public CouchbaseLiteException(@NonNull String message, @NonNull Exception cause) {
        this(message, cause, null, 0, null);
    }

    @Deprecated
    public CouchbaseLiteException(@NonNull String domain, int code) {
        this(null, null, domain, code, null);
    }

    public CouchbaseLiteException(@NonNull String message, @NonNull String domain, int code) {
        this(message, null, domain, code, null);
    }

    @Deprecated
    public CouchbaseLiteException(@NonNull String domain, int code, @NonNull Exception cause) {
        this(null, cause, domain, code, null);
    }

    @Deprecated
    public CouchbaseLiteException(@NonNull String domain, int code, @Nullable Map<String, Object> info) {
        this(null, null, domain, code, info);
    }

    public CouchbaseLiteException(@NonNull String message, @NonNull Exception cause, @NonNull String domain, int code) {
        this(message, cause, domain, code, null);
    }

    public CouchbaseLiteException(@Nullable String message, @Nullable Exception cause, @Nullable String domain, int code, @Nullable Map<String, Object> info) {
        super(CouchbaseLiteException.getErrorMessage(message, cause), cause);
        this.domain = domain != null ? domain : "CouchbaseLite";
        this.code = code > 0 ? code : 10;
        this.info = info;
    }

    @NonNull
    public String getDomain() {
        return this.domain;
    }

    public int getCode() {
        return this.code;
    }

    @Nullable
    public Map<String, Object> getInfo() {
        return this.info;
    }

    @Override
    @NonNull
    public String getMessage() {
        return super.getMessage() + " (" + this.domain + ", " + this.code + ")  [" + CBLVersion.getVersionInfo() + "]";
    }

    @Override
    @NonNull
    public String toString() {
        return "CouchbaseLiteException{" + this.domain + ", " + this.code + ": " + super.getMessage();
    }

    public int hashCode() {
        return 37 * this.domain.hashCode() + this.code;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CouchbaseLiteException)) {
            return false;
        }
        CouchbaseLiteException e = (CouchbaseLiteException)o;
        return this.code == e.code && this.domain.equals(e.domain);
    }
}

