/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.AbstractDatabase;
import com.couchbase.lite.Collection;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.internal.utils.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;

public class DataSource {
    @NonNull
    private final Collection source;
    @Nullable
    protected String alias;

    @Deprecated
    @NonNull
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static As database(@NonNull Database database) {
        Collection defaultCollection;
        Preconditions.assertNotNull(database, "database");
        try {
            defaultCollection = database.getDefaultCollection();
        }
        catch (CouchbaseLiteException e) {
            throw new IllegalArgumentException("Database not open", e);
        }
        As source = new As(defaultCollection);
        source.as(database.getName());
        return source;
    }

    @NonNull
    public static As collection(@NonNull Collection collection) {
        Preconditions.assertNotNull(collection, "collection");
        return new As(collection);
    }

    private DataSource(@NonNull Collection source) {
        this.source = source;
    }

    @NonNull
    AbstractDatabase getDatabase() {
        return this.source.getDatabase();
    }

    @NonNull
    Map<String, Object> asJSON() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("COLLECTION", this.source.getFullName());
        if (this.alias != null) {
            json.put("AS", this.alias);
        }
        return json;
    }

    public static class As
    extends DataSource {
        As(@NonNull Collection source) {
            super(source);
        }

        @NonNull
        public DataSource as(@NonNull String alias) {
            Preconditions.assertNotNull(alias, "alias");
            this.alias = alias;
            return this;
        }
    }
}

