/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.Conflict;
import com.couchbase.lite.ConflictResolver;
import com.couchbase.lite.Document;

class DefaultConflictResolver
implements ConflictResolver {
    DefaultConflictResolver() {
    }

    @Override
    @Nullable
    public Document resolve(@NonNull Conflict conflict) {
        Document localDoc = conflict.getLocalDocument();
        Document remoteDoc = conflict.getRemoteDocument();
        if (localDoc == null || remoteDoc == null) {
            return null;
        }
        int cmp = localDoc.compareAge(remoteDoc);
        if (cmp > 0) {
            return localDoc;
        }
        if (cmp < 0) {
            return remoteDoc;
        }
        String localRevId = localDoc.getRevisionID();
        if (localRevId == null) {
            return remoteDoc;
        }
        String remoteRevId = remoteDoc.getRevisionID();
        return remoteRevId == null || localRevId.compareTo(remoteRevId) <= 0 ? remoteDoc : localDoc;
    }
}

