/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.Collation;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.FullTextIndexExpression;
import com.couchbase.lite.IndexExpression;
import com.couchbase.lite.PropertyExpression;
import com.couchbase.lite.internal.utils.ClassUtils;
import com.couchbase.lite.internal.utils.JSONUtils;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Expression {
    private static final String PARAM_EXPRESSION = "expression";

    @NonNull
    public static Expression value(@Nullable Object value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression string(@Nullable String value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression number(@Nullable Number value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression intValue(int value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression longValue(long value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression floatValue(float value) {
        return new ValueExpression(Float.valueOf(value));
    }

    @NonNull
    public static Expression doubleValue(double value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression booleanValue(boolean value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression date(@Nullable Date value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression map(@Nullable Map<String, Object> value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static Expression list(@Nullable List<Object> value) {
        return new ValueExpression(value);
    }

    @NonNull
    public static PropertyExpression all() {
        return new PropertyExpression("");
    }

    @NonNull
    public static PropertyExpression property(@NonNull String property) {
        Preconditions.assertNotNull(property, "property");
        return new PropertyExpression(property);
    }

    @NonNull
    public static Expression parameter(@NonNull String name) {
        Preconditions.assertNotNull(name, "name");
        return new ParameterExpression(name);
    }

    @NonNull
    public static Expression negated(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new CompoundExpression(Collections.singletonList(expression), "NOT");
    }

    @NonNull
    public static Expression not(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return Expression.negated(expression);
    }

    @NonNull
    public static FullTextIndexExpression fullTextIndex(@NonNull String indexName) {
        return new FTIExpression(Preconditions.assertNotNull(indexName, "indexName"), null);
    }

    @Nullable
    abstract Object asJSON();

    @NonNull
    public String toString() {
        return this.getClass().getSimpleName() + "{" + ClassUtils.objId(this) + ",json=" + this.asJSON() + "}";
    }

    @NonNull
    public Expression multiply(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, "*");
    }

    @NonNull
    public Expression divide(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, "/");
    }

    @NonNull
    public Expression modulo(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, "%");
    }

    @NonNull
    public Expression add(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, "+");
    }

    @NonNull
    public Expression subtract(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, "-");
    }

    @NonNull
    public Expression lessThan(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, "<");
    }

    @NonNull
    public Expression lessThanOrEqualTo(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, "<=");
    }

    @NonNull
    public Expression greaterThan(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, ">");
    }

    @NonNull
    public Expression greaterThanOrEqualTo(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, ">=");
    }

    @NonNull
    public Expression equalTo(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, "=");
    }

    @NonNull
    public Expression notEqualTo(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, "!=");
    }

    @NonNull
    public Expression and(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new CompoundExpression(Arrays.asList(this, expression), "AND");
    }

    @NonNull
    public Expression or(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new CompoundExpression(Arrays.asList(this, expression), "OR");
    }

    @NonNull
    public Expression like(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, "LIKE");
    }

    @NonNull
    public Expression regex(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, "regexp_like()");
    }

    @NonNull
    public Expression is(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, "IS");
    }

    @NonNull
    public Expression isNot(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, PARAM_EXPRESSION);
        return new BinaryExpression(this, expression, "IS NOT");
    }

    @NonNull
    public Expression between(@NonNull Expression expression1, @NonNull Expression expression2) {
        Preconditions.assertNotNull(expression1, "lower bound");
        Preconditions.assertNotNull(expression2, "upper bound");
        AggregateExpression aggr = new AggregateExpression(Arrays.asList(expression1, expression2));
        return new BinaryExpression(this, aggr, "BETWEEN");
    }

    @NonNull
    public Expression collate(@NonNull Collation collation) {
        Preconditions.assertNotNull(collation, "collation");
        return new CollationExpression(this, collation);
    }

    @NonNull
    public Expression in(Expression ... expressions) {
        if (expressions.length <= 0) {
            throw new IllegalArgumentException("empty 'IN'.");
        }
        AggregateExpression aggr = new AggregateExpression(Arrays.asList(expressions));
        return new BinaryExpression(this, aggr, "IN");
    }

    @NonNull
    public Expression isValued() {
        return new UnaryExpression(this, 1001);
    }

    @NonNull
    public Expression isNotValued() {
        return Expression.negated(new UnaryExpression(this, 1001));
    }

    @Deprecated
    @NonNull
    public Expression isNullOrMissing() {
        return new UnaryExpression(this, 1002).or(new UnaryExpression(this, 1003));
    }

    @Deprecated
    @NonNull
    public Expression notNullOrMissing() {
        return Expression.negated(this.isNullOrMissing());
    }

    static final class UnaryExpression
    extends Expression {
        private static final int OP_VALUED = 1001;
        @Deprecated
        private static final int OP_NULL = 1002;
        @Deprecated
        private static final int OP_MISSING = 1003;
        @NonNull
        private final Expression operand;
        private final int op;

        UnaryExpression(@NonNull Expression operand, int op) {
            Preconditions.assertNotNull(operand, "operand");
            this.operand = operand;
            this.op = op;
        }

        @Override
        @NonNull
        Object asJSON() {
            ArrayList<Object> json = new ArrayList<Object>();
            String opStr = "IS";
            if (this.op == 1001) {
                opStr = opStr + " VALUED";
            }
            json.add(opStr);
            json.add(this.operand.asJSON());
            switch (this.op) {
                case 1001: {
                    break;
                }
                case 1002: {
                    json.add(null);
                    break;
                }
                case 1003: {
                    json.add(Collections.singletonList("MISSING"));
                    break;
                }
                default: {
                    throw new CouchbaseLiteError("Unexpected unary type: " + this.op);
                }
            }
            return json;
        }
    }

    static final class BinaryExpression
    extends Expression {
        private static final String OP_ADD = "+";
        private static final String OP_BETWEEN = "BETWEEN";
        private static final String OP_DIVIDE = "/";
        private static final String OP_EQUALS = "=";
        private static final String OP_GREATER = ">";
        private static final String OP_GREATER_OR_EQUAL = ">=";
        private static final String OP_IN = "IN";
        private static final String OP_IS = "IS";
        private static final String OP_IS_NOT = "IS NOT";
        private static final String OP_LESS = "<";
        private static final String OP_LESS_OR_EQUAL = "<=";
        private static final String OP_LIKE = "LIKE";
        private static final String OP_MODULO = "%";
        private static final String OP_MULTIPLY = "*";
        private static final String OP_NOT_EQUAL = "!=";
        private static final String OP_SUBTRACT = "-";
        private static final String OP_REGEX_LIKE = "regexp_like()";
        @NonNull
        private final Expression lhs;
        @NonNull
        private final Expression rhs;
        @NonNull
        private final String op;

        BinaryExpression(@NonNull Expression lhs, @NonNull Expression rhs, @NonNull String op) {
            this.lhs = lhs;
            this.rhs = rhs;
            this.op = op;
        }

        @Override
        @NonNull
        Object asJSON() {
            ArrayList<Object> json = new ArrayList<Object>();
            json.add(this.op);
            json.add(this.lhs.asJSON());
            if (!OP_BETWEEN.equals(this.op)) {
                json.add(this.rhs.asJSON());
            } else {
                List<Expression> rangeExprs = ((AggregateExpression)this.rhs).getExpressions();
                json.add(rangeExprs.get(0).asJSON());
                json.add(rangeExprs.get(1).asJSON());
            }
            return json;
        }
    }

    static final class CompoundExpression
    extends Expression {
        private static final String OP_AND = "AND";
        private static final String OP_OR = "OR";
        private static final String OP_NOT = "NOT";
        @NonNull
        private final String op;
        @NonNull
        private final List<Expression> subexpressions;

        CompoundExpression(@NonNull List<Expression> subexpressions, @NonNull String op) {
            Preconditions.assertNotNull(subexpressions, "subexpressions");
            this.op = op;
            this.subexpressions = subexpressions;
        }

        @Override
        @NonNull
        Object asJSON() {
            ArrayList<Object> json = new ArrayList<Object>();
            json.add(this.op);
            for (Expression expr : this.subexpressions) {
                json.add(expr.asJSON());
            }
            return json;
        }
    }

    static final class ValueExpression
    extends Expression {
        @Nullable
        private final Object value;

        ValueExpression(@Nullable Object value) {
            this.verifySupportedType(value);
            this.value = value;
        }

        @Override
        @Nullable
        Object asJSON() {
            return this.asJSON(this.value);
        }

        @Nullable
        private Object asJSON(@Nullable Object value) {
            if (value instanceof Date) {
                return JSONUtils.toJSONString((Date)value);
            }
            if (value instanceof Map) {
                return this.mapAsJSON((Map)value);
            }
            if (value instanceof List) {
                return this.listAsJSON((List)value);
            }
            if (value instanceof Expression) {
                return ((Expression)value).asJSON();
            }
            this.verifySupportedType(value);
            return value;
        }

        @NonNull
        private Object mapAsJSON(@NonNull Map<String, Object> map) {
            HashMap<String, Object> json = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                json.put(entry.getKey(), this.asJSON(entry.getValue()));
            }
            return json;
        }

        @NonNull
        private Object listAsJSON(@NonNull List<Object> list) {
            ArrayList<Object> json = new ArrayList<Object>();
            json.add("[]");
            for (Object obj : list) {
                json.add(this.asJSON(obj));
            }
            return json;
        }

        private void verifySupportedType(@Nullable Object value) {
            if (value == null || value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Date || value instanceof Map || value instanceof List || value instanceof Expression) {
                return;
            }
            throw new IllegalArgumentException("Unsupported expression value type: " + value.getClass());
        }
    }

    static final class ParameterExpression
    extends Expression {
        @NonNull
        private final String name;

        ParameterExpression(@NonNull String name) {
            this.name = name;
        }

        @Override
        @NonNull
        Object asJSON() {
            ArrayList<String> json = new ArrayList<String>();
            json.add("$" + this.name);
            return json;
        }
    }

    static final class FTIExpression
    implements FullTextIndexExpression {
        @NonNull
        private final String name;
        @Nullable
        private final String alias;

        FTIExpression(@NonNull String name, @Nullable String alias) {
            this.name = name;
            this.alias = alias;
        }

        @Override
        @NonNull
        public IndexExpression from(@NonNull String alias) {
            return new FTIExpression(this.name, Preconditions.assertNotNull(alias, "alias"));
        }

        @NonNull
        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.alias != null) {
                buf.append(this.alias).append('.');
            }
            return buf.append(this.name).toString();
        }
    }

    static final class AggregateExpression
    extends Expression {
        @NonNull
        private final List<Expression> expressions;

        AggregateExpression(@NonNull List<Expression> expressions) {
            this.expressions = expressions;
        }

        @NonNull
        public List<Expression> getExpressions() {
            return this.expressions;
        }

        @Override
        @NonNull
        Object asJSON() {
            ArrayList<Object> json = new ArrayList<Object>();
            json.add("[]");
            for (Expression expr : this.expressions) {
                json.add(expr.asJSON());
            }
            return json;
        }
    }

    static final class CollationExpression
    extends Expression {
        @NonNull
        private final Expression operand;
        @NonNull
        private final Collation collation;

        CollationExpression(@NonNull Expression operand, @NonNull Collation collation) {
            this.operand = operand;
            this.collation = collation;
        }

        @Override
        @NonNull
        Object asJSON() {
            ArrayList<Object> json = new ArrayList<Object>(3);
            json.add("COLLATE");
            json.add(this.collation.asJSON());
            json.add(this.operand.asJSON());
            return json;
        }
    }

    static final class IdxExpression
    extends Expression {
        @NonNull
        private final String func;
        @NonNull
        private final IndexExpression idx;
        @Nullable
        private final List<Expression> params;

        IdxExpression(@NonNull String func, @NonNull IndexExpression idx, Expression ... params) {
            this.func = func;
            this.idx = idx;
            this.params = params == null ? null : Arrays.asList(params);
        }

        @Override
        @NonNull
        Object asJSON() {
            ArrayList<Object> json = new ArrayList<Object>();
            json.add(this.func);
            json.add(this.idx.toString());
            if (this.params != null) {
                for (Expression expr : this.params) {
                    json.add(expr.asJSON());
                }
            }
            return json;
        }
    }

    static final class FunctionExpression
    extends Expression {
        @NonNull
        private final String func;
        @NonNull
        private final List<Expression> params;

        FunctionExpression(@NonNull String func, Expression ... params) {
            this.func = func;
            this.params = Arrays.asList(params);
        }

        @Override
        @NonNull
        Object asJSON() {
            ArrayList<Object> json = new ArrayList<Object>();
            json.add(this.func);
            for (Expression expr : this.params) {
                json.add(expr.asJSON());
            }
            return json;
        }
    }
}

