/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogFileConfiguration;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.Logger;
import com.couchbase.lite.internal.core.C4Log;
import com.couchbase.lite.internal.core.CBLVersion;
import com.couchbase.lite.internal.logging.Log;
import java.io.File;
import java.util.Objects;

public final class FileLogger
implements Logger {
    @NonNull
    private final C4Log c4Log;
    @Nullable
    private volatile LogFileConfiguration config;
    @NonNull
    private volatile LogLevel logLevel = LogLevel.NONE;

    FileLogger(@NonNull C4Log c4Log) {
        this.c4Log = c4Log;
    }

    @Override
    public void log(@NonNull LogLevel level, @NonNull LogDomain domain, @NonNull String message) {
        if (this.config == null || level.compareTo(this.logLevel) < 0) {
            return;
        }
        this.c4Log.logToCore(domain, level, message);
    }

    @Override
    @NonNull
    public LogLevel getLevel() {
        return this.logLevel;
    }

    public void setLevel(@NonNull LogLevel level) {
        if (this.config == null) {
            throw new CouchbaseLiteError(Log.lookupStandardMessage("CannotSetLogLevel"));
        }
        if (this.logLevel == level) {
            return;
        }
        this.c4Log.setFileLogLevel(level);
        this.logLevel = level;
        if (level == LogLevel.NONE) {
            Log.warn();
        }
    }

    @Nullable
    public LogFileConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(@Nullable LogFileConfiguration newConfig) {
        LogFileConfiguration oldConfig = this.config;
        if (Objects.equals(newConfig, oldConfig)) {
            return;
        }
        if (newConfig == null || newConfig.getDirectory().isEmpty()) {
            this.reset(oldConfig != null);
            Log.warn();
            return;
        }
        String logDirPath = newConfig.getDirectory();
        File logDir = new File(logDirPath);
        if (!logDir.exists()) {
            if (!logDir.mkdirs()) {
                Log.w(LogDomain.DATABASE, "Cannot create log directory: " + logDir.getAbsolutePath());
                return;
            }
        } else {
            if (!logDir.isDirectory()) {
                Log.w(LogDomain.DATABASE, logDir.getAbsolutePath() + " is not a directory");
                return;
            }
            if (!logDir.canWrite()) {
                Log.w(LogDomain.DATABASE, logDir.getAbsolutePath() + " is not writable");
                return;
            }
        }
        LogFileConfiguration cfg = new LogFileConfiguration(logDirPath, newConfig, true);
        this.c4Log.initFileLogger(logDirPath, this.logLevel, cfg.getMaxRotateCount(), cfg.getMaxSize(), cfg.usesPlaintext(), CBLVersion.getVersionInfo());
        this.config = cfg;
    }

    @VisibleForTesting
    void reset(boolean hard) {
        this.config = null;
        this.logLevel = LogLevel.NONE;
        if (hard) {
            this.c4Log.initFileLogger("", LogLevel.NONE, 0, 0L, false, "");
        }
    }
}

