/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import com.couchbase.lite.Expression;
import com.couchbase.lite.IndexExpression;
import com.couchbase.lite.internal.utils.Preconditions;

public final class FullTextFunction {
    private FullTextFunction() {
    }

    @NonNull
    public static Expression rank(@NonNull IndexExpression index) {
        return new Expression.IdxExpression("RANK()", Preconditions.assertNotNull(index, "index"), new Expression[0]);
    }

    @NonNull
    public static Expression match(@NonNull IndexExpression index, @NonNull String query) {
        return new Expression.IdxExpression("MATCH()", Preconditions.assertNotNull(index, "index"), Expression.string(query));
    }

    @Deprecated
    @NonNull
    public static Expression rank(@NonNull String indexName) {
        return new Expression.FunctionExpression("RANK()", Expression.string(Preconditions.assertNotNull(indexName, "indexName")));
    }

    @Deprecated
    @NonNull
    public static Expression match(@NonNull String indexName, @NonNull String query) {
        return new Expression.FunctionExpression("MATCH()", Expression.string(Preconditions.assertNotNull(indexName, "indexName")), Expression.string(query));
    }
}

