/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.FullTextIndexItem;
import com.couchbase.lite.Index;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.internal.QueryLanguage;
import com.couchbase.lite.internal.core.C4Collection;
import com.couchbase.lite.internal.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public final class FullTextIndex
extends Index {
    @NonNull
    private final List<FullTextIndexItem> indexItems;
    @Nullable
    private String language = Locale.getDefault().getLanguage();
    private boolean ignoreDiacrits = false;

    FullTextIndex(FullTextIndexItem ... indexItems) {
        this.indexItems = Arrays.asList(indexItems);
    }

    @NonNull
    public FullTextIndex setLanguage(@Nullable String language) {
        this.language = StringUtils.isEmpty(language) ? null : language;
        return this;
    }

    @Nullable
    public String getLanguage() {
        return this.language;
    }

    @NonNull
    public FullTextIndex ignoreAccents(boolean ignoreAccents) {
        this.ignoreDiacrits = ignoreAccents;
        return this;
    }

    public boolean isIgnoringAccents() {
        return this.ignoreDiacrits;
    }

    @Override
    @NonNull
    List<Object> getJson() {
        ArrayList<Object> items = new ArrayList<Object>();
        for (FullTextIndexItem item : this.indexItems) {
            items.add(item.expression.asJSON());
        }
        return items;
    }

    @Override
    void createIndex(@NonNull String name, @NonNull C4Collection c4Collection) throws LiteCoreException, CouchbaseLiteException {
        c4Collection.createFullTextIndex(name, QueryLanguage.JSON.getCode(), this.getIndexSpec(), this.language, this.ignoreDiacrits);
    }
}

