/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.BuilderQuery;
import com.couchbase.lite.Expression;
import com.couchbase.lite.Having;
import com.couchbase.lite.HavingRouter;
import com.couchbase.lite.Limit;
import com.couchbase.lite.LimitRouter;
import com.couchbase.lite.OrderBy;
import com.couchbase.lite.OrderByRouter;
import com.couchbase.lite.Ordering;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GroupBy
extends BuilderQuery
implements HavingRouter,
OrderByRouter,
LimitRouter {
    @NonNull
    private final List<Expression> expressions;

    GroupBy(@NonNull BuilderQuery query, @NonNull List<Expression> expressions) {
        this.copy(query);
        this.expressions = expressions;
        this.setGroupBy(this);
    }

    @Override
    @NonNull
    public Having having(@NonNull Expression expression) {
        Preconditions.assertNotNull(expression, "expression");
        return new Having(this, expression);
    }

    @Override
    @NonNull
    public OrderBy orderBy(Ordering ... orderings) {
        Preconditions.assertNotNull(orderings, "foo");
        return new OrderBy(this, Arrays.asList(orderings));
    }

    @Override
    @NonNull
    public Limit limit(@NonNull Expression limit) {
        return this.limit(limit, null);
    }

    @Override
    @NonNull
    public Limit limit(@NonNull Expression limit, @Nullable Expression offset) {
        Preconditions.assertNotNull(limit, "limit");
        return new Limit(this, limit, offset);
    }

    @NonNull
    Object asJSON() {
        ArrayList<Object> groupBy = new ArrayList<Object>();
        for (Expression expression : this.expressions) {
            groupBy.add(expression.asJSON());
        }
        return groupBy;
    }
}

