/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import com.couchbase.lite.AbstractIndex;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import com.couchbase.lite.internal.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class IndexConfiguration
extends AbstractIndex {
    @NonNull
    private final List<String> expressions;

    IndexConfiguration(String ... expressions) {
        this(Arrays.asList(expressions));
    }

    IndexConfiguration(@NonNull List<String> expressions) {
        this.expressions = Preconditions.assertNotEmpty(Fn.filterToList(expressions, s -> !StringUtils.isEmpty(s)), "expression list");
    }

    @NonNull
    public List<String> getExpressions() {
        return new ArrayList<String>(this.expressions);
    }

    @Override
    @NonNull
    String getIndexSpec() {
        return StringUtils.join(",", this.expressions);
    }
}

