/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import com.couchbase.lite.DataSource;
import com.couchbase.lite.Expression;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.HashMap;

public class Join {
    @NonNull
    private final Type type;
    @NonNull
    private final DataSource dataSource;

    @NonNull
    public static On join(@NonNull DataSource datasource) {
        return Join.innerJoin(datasource);
    }

    @NonNull
    public static On innerJoin(@NonNull DataSource datasource) {
        Preconditions.assertNotNull(datasource, "data source");
        return new On(Type.INNER, datasource);
    }

    @NonNull
    public static On leftJoin(@NonNull DataSource datasource) {
        Preconditions.assertNotNull(datasource, "data source");
        return Join.leftOuterJoin(datasource);
    }

    @NonNull
    public static On leftOuterJoin(@NonNull DataSource datasource) {
        Preconditions.assertNotNull(datasource, "data source");
        return new On(Type.LEFT_OUTER, datasource);
    }

    @NonNull
    public static Join crossJoin(@NonNull DataSource datasource) {
        Preconditions.assertNotNull(datasource, "data source");
        return new Join(Type.CROSS, datasource);
    }

    private Join(@NonNull Type type, @NonNull DataSource datasource) {
        Preconditions.assertNotNull(type, "type");
        Preconditions.assertNotNull(datasource, "data source");
        this.type = type;
        this.dataSource = datasource;
    }

    @NonNull
    Object asJSON() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("JOIN", this.type.getTag());
        json.putAll(this.dataSource.asJSON());
        return json;
    }

    static enum Type {
        INNER("INNER"),
        LEFT_OUTER("LEFT OUTER"),
        CROSS("CROSS");

        @NonNull
        private final String tag;

        private Type(String tag) {
            this.tag = tag;
        }

        @NonNull
        public String getTag() {
            return this.tag;
        }
    }

    public static final class On
    extends Join {
        private Expression onExpression;

        private On(@NonNull Type type, @NonNull DataSource datasource) {
            super(type, datasource);
        }

        @NonNull
        public Join on(@NonNull Expression expression) {
            Preconditions.assertNotNull(expression, "expression");
            this.onExpression = expression;
            return this;
        }

        @Override
        @NonNull
        Object asJSON() {
            HashMap<String, Object> json = new HashMap<String, Object>();
            json.put("JOIN", ((Join)this).type.getTag());
            json.put("ON", this.onExpression.asJSON());
            json.putAll(((Join)this).dataSource.asJSON());
            return json;
        }
    }
}

