/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ListenerToken
implements AutoCloseable {
    @Nullable
    private final Executor executor;
    private final Fn.Consumer<ListenerToken> onRemove;
    private final AtomicBoolean active = new AtomicBoolean(true);

    protected ListenerToken(@Nullable Executor executor, @NonNull Fn.Consumer<ListenerToken> onRemove) {
        this.executor = executor;
        this.onRemove = Preconditions.assertNotNull(onRemove, "onRemove task");
    }

    @NonNull
    public String toString() {
        return " on " + this.executor + " then " + this.onRemove;
    }

    @Override
    public void close() {
        this.remove();
    }

    public void remove() {
        if (this.active.getAndSet(false)) {
            this.onRemove.accept(this);
        }
    }

    protected void send(@NonNull Runnable notification) {
        this.getExecutor().execute(notification);
    }

    @VisibleForTesting
    boolean isActive() {
        return this.active.get();
    }

    @VisibleForTesting
    @NonNull
    Executor getExecutor() {
        return this.executor != null ? this.executor : CouchbaseLiteInternal.getExecutionService().getDefaultExecutor();
    }
}

