/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.ConsoleLogger;
import com.couchbase.lite.FileLogger;
import com.couchbase.lite.Logger;
import com.couchbase.lite.internal.CouchbaseLiteInternal;
import com.couchbase.lite.internal.core.C4Log;

public final class Log {
    private final ConsoleLogger consoleLogger = new ConsoleLogger(C4Log.get());
    private final FileLogger fileLogger = new FileLogger(C4Log.get());
    @Nullable
    private Logger customLogger;

    Log() {
    }

    @NonNull
    public ConsoleLogger getConsole() {
        CouchbaseLiteInternal.requireInit("Console logging not initialized");
        return this.consoleLogger;
    }

    @NonNull
    public FileLogger getFile() {
        CouchbaseLiteInternal.requireInit("File logging not initialized");
        return this.fileLogger;
    }

    @Nullable
    public Logger getCustom() {
        return this.customLogger;
    }

    public void setCustom(@Nullable Logger customLogger) {
        this.customLogger = customLogger;
    }

    @VisibleForTesting
    void reset() {
        this.consoleLogger.reset();
        this.fileLogger.reset(true);
        this.customLogger = null;
    }
}

