/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.logging.Log;
import java.util.EnumMap;

public enum LogLevel {
    DEBUG,
    VERBOSE,
    INFO,
    WARNING,
    ERROR,
    NONE;

    private static final EnumMap<LogLevel, String> LEVELS;

    @NonNull
    public String toString() {
        String s = LEVELS.get((Object)this);
        if (s != null) {
            return s;
        }
        Log.d(LogDomain.DATABASE, "Unrecognized log level: %s", new Object[]{this});
        return "?";
    }

    static {
        LEVELS = new EnumMap(LogLevel.class);
        LEVELS.put(DEBUG, "D");
        LEVELS.put(VERBOSE, "V");
        LEVELS.put(INFO, "I");
        LEVELS.put(WARNING, "W");
        LEVELS.put(ERROR, "E");
        LEVELS.put(NONE, "");
    }
}

