/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.Array;
import com.couchbase.lite.Blob;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.MutableArray;
import com.couchbase.lite.MutableDictionary;
import com.couchbase.lite.internal.DbContext;
import com.couchbase.lite.internal.fleece.FLDict;
import com.couchbase.lite.internal.fleece.FLValue;
import com.couchbase.lite.internal.fleece.MCollection;
import com.couchbase.lite.internal.fleece.MContext;
import com.couchbase.lite.internal.fleece.MValue;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.utils.Preconditions;

public abstract class MValueConverter {
    protected MValueConverter() {
    }

    @NonNull
    protected NativeValue<?> toNative(@NonNull MValue val, @Nullable MCollection parent) {
        FLValue value = Preconditions.assertNotNull(val.getValue(), "value");
        switch (value.getType()) {
            case 6: {
                return this.mValueToDictionary(val, Preconditions.assertNotNull(parent, "parent"));
            }
            case 5: {
                return new NativeValue<Array>(parent == null || !parent.hasMutableChildren() ? new Array(val, parent) : new MutableArray(val, parent), true);
            }
            case 4: {
                return new NativeValue<Blob>(new Blob("application/octet-stream", value.asData()), false);
            }
        }
        return new NativeValue<Object>(value.asObject(), false);
    }

    @NonNull
    private NativeValue<?> mValueToDictionary(@NonNull MValue mv, @NonNull MCollection parent) {
        String type;
        MContext ctxt = parent.getContext();
        if (!(ctxt instanceof DbContext)) {
            throw new CouchbaseLiteError("Context is not DbContext: " + ctxt);
        }
        DbContext context = (DbContext)ctxt;
        FLDict flDict = Preconditions.assertNotNull(mv.getValue(), "MValue").asFLDict();
        FLValue flType = flDict.get("@type");
        String string = type = flType == null ? null : flType.asString();
        if ("blob".equals(type) || type == null && this.isOldAttachment(flDict)) {
            return new NativeValue<Blob>(new Blob(Preconditions.assertNotNull(context.getDatabase(), "database"), flDict.asDict()), true);
        }
        return new NativeValue<MutableDictionary>((MutableDictionary)(parent.hasMutableChildren() ? new MutableDictionary(mv, parent) : new Dictionary(mv, parent)), true);
    }

    private boolean isOldAttachment(@NonNull FLDict flDict) {
        boolean ret;
        boolean bl = ret = flDict.get("digest") != null && flDict.get("length") != null && flDict.get("stub") != null && flDict.get("revpos") != null;
        if (ret) {
            Log.i(LogDomain.DATABASE, "Old style blob: " + flDict.asDict());
        }
        return ret;
    }

    public static final class NativeValue<T> {
        public final boolean cacheIt;
        @Nullable
        public final T nVal;

        public NativeValue(@Nullable T nVal, boolean cacheIt) {
            this.cacheIt = cacheIt;
            this.nVal = nVal;
        }
    }
}

