/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.Array;
import com.couchbase.lite.Blob;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.Fleece;
import com.couchbase.lite.MutableArray;
import com.couchbase.lite.MutableDictionaryInterface;
import com.couchbase.lite.internal.fleece.MCollection;
import com.couchbase.lite.internal.fleece.MDict;
import com.couchbase.lite.internal.fleece.MValue;
import com.couchbase.lite.internal.utils.JSONUtils;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.Date;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class MutableDictionary
extends Dictionary
implements MutableDictionaryInterface {
    public MutableDictionary() {
    }

    public MutableDictionary(@NonNull Map<String, Object> data) {
        this.setData((Map)data);
    }

    public MutableDictionary(@NonNull String json) {
        this.setJSON(json);
    }

    MutableDictionary(@NonNull Dictionary dict) {
        super(new MDict(dict.internalDict, true));
    }

    MutableDictionary(@NonNull MValue val, @Nullable MCollection parent) {
        super(val, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableDictionary setData(@NonNull Map<String, Object> data) {
        Object object = this.lock;
        synchronized (object) {
            this.internalDict.clear();
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                this.internalDict.set(Preconditions.assertNotNull(entry.getKey(), "data key"), new MValue(this.toFleece(entry.getValue())));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableDictionary setJSON(@NonNull String json) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.setData((Map)JSONUtils.fromJSON(new JSONObject(json)));
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Failed parsing JSON", e);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableDictionary setValue(@NonNull String key, @Nullable Object value) {
        Preconditions.assertNotNull(key, "key");
        Object val = this.toFleece(value);
        Object object = this.lock;
        synchronized (object) {
            if (Fleece.willMutate(val, this.internalDict.get(key), this.internalDict)) {
                this.internalDict.set(key, new MValue(val));
            }
        }
        return this;
    }

    @Override
    @NonNull
    public MutableDictionary setString(@NonNull String key, @Nullable String value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setNumber(@NonNull String key, @Nullable Number value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setInt(@NonNull String key, int value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setLong(@NonNull String key, long value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setFloat(@NonNull String key, float value) {
        return this.setValue(key, Float.valueOf(value));
    }

    @Override
    @NonNull
    public MutableDictionary setDouble(@NonNull String key, double value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setBoolean(@NonNull String key, boolean value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setBlob(@NonNull String key, @Nullable Blob value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setDate(@NonNull String key, @Nullable Date value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setArray(@NonNull String key, @Nullable Array value) {
        return this.setValue(key, value);
    }

    @Override
    @NonNull
    public MutableDictionary setDictionary(@NonNull String key, @Nullable Dictionary value) {
        return this.setValue(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableDictionary remove(@NonNull String key) {
        Preconditions.assertNotNull(key, "key");
        Object object = this.lock;
        synchronized (object) {
            this.internalDict.remove(key);
        }
        return this;
    }

    @Override
    @Nullable
    public MutableArray getArray(@NonNull String key) {
        return (MutableArray)super.getArray(key);
    }

    @Override
    @Nullable
    public MutableDictionary getDictionary(@NonNull String key) {
        return (MutableDictionary)super.getDictionary(key);
    }

    @Override
    @NonNull
    public String toJSON() {
        throw new CouchbaseLiteError("Mutable objects may not be encoded as JSON");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean isChanged() {
        Object object = this.lock;
        synchronized (object) {
            return this.internalDict.isMutated();
        }
    }

    @Nullable
    private Object toFleece(@Nullable Object value) {
        return value == this ? ((Dictionary)value).toMutable() : Fleece.toCBLObject(value);
    }
}

