/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.Array;
import com.couchbase.lite.Blob;
import com.couchbase.lite.CouchbaseLiteError;
import com.couchbase.lite.Dictionary;
import com.couchbase.lite.Fleece;
import com.couchbase.lite.LiteCoreException;
import com.couchbase.lite.internal.fleece.FLEncoder;
import com.couchbase.lite.internal.fleece.FLSliceResult;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class Parameters {
    @NonNull
    private final Map<String, Object> map;
    private final boolean readonly;

    public Parameters() {
        this(null);
    }

    public Parameters(@Nullable Parameters parameters) {
        this(parameters, false);
    }

    private Parameters(@Nullable Parameters parameters, boolean readonly) {
        this.map = parameters == null ? new HashMap<String, Object>() : new HashMap<String, Object>(parameters.map);
        this.readonly = readonly;
    }

    @Nullable
    public Object getValue(@NonNull String name) {
        Preconditions.assertNotNull(name, "name");
        return this.map.get(name);
    }

    @NonNull
    public Parameters setString(@NonNull String name, @Nullable String value) {
        return this.setValue(name, value);
    }

    @NonNull
    public Parameters setNumber(@NonNull String name, @Nullable Number value) {
        return this.setValue(name, value);
    }

    @NonNull
    public Parameters setInt(@NonNull String name, int value) {
        return this.setValue(name, value);
    }

    @NonNull
    public Parameters setLong(@NonNull String name, long value) {
        return this.setValue(name, value);
    }

    @NonNull
    public Parameters setFloat(@NonNull String name, float value) {
        return this.setValue(name, Float.valueOf(value));
    }

    @NonNull
    public Parameters setDouble(@NonNull String name, double value) {
        return this.setValue(name, value);
    }

    @NonNull
    public Parameters setBoolean(@NonNull String name, boolean value) {
        return this.setValue(name, value);
    }

    @NonNull
    public Parameters setDate(@NonNull String name, @Nullable Date value) {
        return this.setValue(name, value);
    }

    @NonNull
    public Parameters setBlob(@NonNull String name, @Nullable Blob value) {
        return this.setValue(name, value);
    }

    @NonNull
    public Parameters setDictionary(@NonNull String name, @Nullable Dictionary value) {
        return this.setValue(name, value);
    }

    @NonNull
    public Parameters setArray(@NonNull String name, @Nullable Array value) {
        return this.setValue(name, value);
    }

    @NonNull
    public Parameters setValue(@NonNull String name, @Nullable Object value) {
        Preconditions.assertNotNull(name, "name");
        if (this.readonly) {
            throw new CouchbaseLiteError("Parameters is readonly mode.");
        }
        this.map.put(name, Fleece.toCBLObject(value));
        return this;
    }

    @NonNull
    Parameters readonlyCopy() {
        return new Parameters(this, true);
    }

    @NonNull
    FLSliceResult encode() throws LiteCoreException {
        try (FLEncoder encoder = FLEncoder.getManagedEncoder();){
            encoder.setArg("BLOB.queryParam", true);
            encoder.write(this.map);
            FLSliceResult fLSliceResult = encoder.finish2();
            return fLSliceResult;
        }
    }
}

