/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.DocumentFlag;
import com.couchbase.lite.internal.core.C4Constants;
import java.util.EnumSet;

public final class ReplicatedDocument {
    @NonNull
    private final String scope;
    @NonNull
    private final String name;
    @NonNull
    private final String docId;
    @NonNull
    private final EnumSet<DocumentFlag> flags;
    @Nullable
    private volatile CouchbaseLiteException error;

    ReplicatedDocument(@NonNull String scope, @NonNull String name, @NonNull String docId, int flags, @Nullable CouchbaseLiteException error) {
        this.scope = scope;
        this.name = name;
        this.docId = docId;
        this.error = error;
        this.flags = EnumSet.noneOf(DocumentFlag.class);
        if (C4Constants.hasFlags(flags, 1)) {
            this.flags.add(DocumentFlag.DELETED);
        }
        if (C4Constants.hasFlags(flags, 128)) {
            this.flags.add(DocumentFlag.ACCESS_REMOVED);
        }
    }

    @Deprecated
    @NonNull
    public String getCollectionScope() {
        return this.scope;
    }

    @NonNull
    public String getScope() {
        return this.scope;
    }

    @Deprecated
    @NonNull
    public String getCollectionName() {
        return this.name;
    }

    @NonNull
    public String getCollection() {
        return this.name;
    }

    @NonNull
    public String getID() {
        return this.docId;
    }

    @NonNull
    public EnumSet<DocumentFlag> getFlags() {
        return this.flags;
    }

    @Nullable
    public CouchbaseLiteException getError() {
        return this.error;
    }

    public void setError(@Nullable CouchbaseLiteException error) {
        this.error = error;
    }

    @NonNull
    public String toString() {
        return "ReplicatedDocument{@" + this.docId + ", " + this.error + "}";
    }
}

