/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.ReplicatorChange;
import com.couchbase.lite.ReplicatorChangeListener;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import java.util.concurrent.Executor;

final class ReplicatorChangeListenerToken
extends ListenerToken {
    @NonNull
    private final ReplicatorChangeListener listener;

    ReplicatorChangeListenerToken(@Nullable Executor executor, @NonNull ReplicatorChangeListener listener, @NonNull Fn.Consumer<ListenerToken> onRemove) {
        super(executor, onRemove);
        this.listener = Preconditions.assertNotNull(listener, "listener");
    }

    @Override
    @NonNull
    public String toString() {
        return "ReplicatorChangeListenerToken{" + this.listener + super.toString() + "}";
    }

    void postChange(@NonNull ReplicatorChange change) {
        this.send(() -> this.listener.changed(change));
    }
}

