/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import androidx.annotation.NonNull;
import com.couchbase.lite.Endpoint;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.utils.Preconditions;
import java.net.URI;

public final class URLEndpoint
implements Endpoint {
    static final String SCHEME_STD = "ws";
    static final String SCHEME_TLS = "wss";
    @NonNull
    private final URI url;

    public URLEndpoint(@NonNull URI url) {
        Preconditions.assertNotNull(url, "url");
        String scheme = url.getScheme();
        if (!SCHEME_STD.equals(scheme) && !SCHEME_TLS.equals(scheme)) {
            throw new IllegalArgumentException(Log.formatStandardMessage("InvalidSchemeURLEndpoint", url.toString()));
        }
        if (url.getUserInfo() != null) {
            throw new IllegalArgumentException(Log.lookupStandardMessage("InvalidEmbeddedCredentialsInURL"));
        }
        this.url = url;
    }

    @NonNull
    public String toString() {
        return "URLEndpoint{url=" + this.url + '}';
    }

    @NonNull
    public URI getURL() {
        return this.url;
    }
}

