/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.couchbase.lite.Endpoint;
import com.couchbase.lite.ReplicatorConfiguration;
import com.couchbase.lite.URLEndpoint;
import com.couchbase.lite.internal.BaseSocketFactory;
import com.couchbase.lite.internal.replicator.CBLCookieStore;
import com.couchbase.lite.internal.replicator.CBLWebSocket;
import com.couchbase.lite.internal.sockets.CBLSocketException;
import com.couchbase.lite.internal.sockets.OkHttpSocket;
import com.couchbase.lite.internal.sockets.SocketFromCore;
import com.couchbase.lite.internal.sockets.SocketToCore;
import com.couchbase.lite.internal.utils.Fn;
import com.couchbase.lite.internal.utils.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.Certificate;
import java.util.List;

public abstract class AbstractSocketFactory
implements BaseSocketFactory {
    @NonNull
    private final CBLCookieStore cookieStore;
    @NonNull
    private final Fn.Consumer<List<Certificate>> serverCertsListener;
    @NonNull
    protected final Endpoint endpoint;
    @GuardedBy(value="endpoint")
    @Nullable
    private Fn.Consumer<SocketFromCore> testListener;

    public AbstractSocketFactory(@NonNull ReplicatorConfiguration config, @NonNull CBLCookieStore cookieStore, @NonNull Fn.Consumer<List<Certificate>> serverCertsListener) {
        this.endpoint = config.getTarget();
        this.cookieStore = cookieStore;
        this.serverCertsListener = serverCertsListener;
    }

    @Override
    @NonNull
    public final SocketFromCore createSocket(@NonNull SocketToCore toCore, @NonNull String scheme, @NonNull String host, int port, @NonNull String path, @NonNull byte[] opts) {
        SocketFromCore fromCore;
        SocketFromCore socketFromCore = fromCore = this.endpoint instanceof URLEndpoint ? this.createCBLWebSocket(toCore, scheme, host, port, path, opts) : this.createPlatformSocket(toCore);
        if (fromCore == null) {
            throw new CBLSocketException(6, 1011, "Can't create endpoint: " + this.endpoint);
        }
        Fn.Consumer<SocketFromCore> testListener = this.getTestListener();
        if (testListener != null) {
            testListener.accept(fromCore);
        }
        return fromCore;
    }

    @NonNull
    public String toString() {
        return "SocketFactory{@" + this.endpoint + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void setTestListener(@Nullable Fn.Consumer<SocketFromCore> testListener) {
        Endpoint endpoint = this.endpoint;
        synchronized (endpoint) {
            this.testListener = testListener;
        }
    }

    @Nullable
    protected abstract SocketFromCore createPlatformSocket(@NonNull SocketToCore var1);

    @NonNull
    private SocketFromCore createCBLWebSocket(@NonNull SocketToCore toCore, @NonNull String scheme, @NonNull String host, int port, @NonNull String path, @NonNull byte[] opts) {
        URI uri;
        try {
            uri = new URI(this.translateScheme(scheme), null, host, port, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new CBLSocketException(5, 4, String.format("Bad URI for socket: %s//%s:%d/%s", scheme, host, port, path), e);
        }
        OkHttpSocket toRemote = new OkHttpSocket();
        CBLWebSocket socket = new CBLWebSocket(toRemote, toCore, uri, opts, this.cookieStore, this.serverCertsListener);
        toRemote.init(socket);
        return socket;
    }

    @NonNull
    private String translateScheme(@NonNull String scheme) {
        Preconditions.assertNotNull(scheme, "scheme");
        if ("blip".equalsIgnoreCase(scheme)) {
            return "ws";
        }
        if ("blips".equalsIgnoreCase(scheme)) {
            return "wss";
        }
        return scheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Fn.Consumer<SocketFromCore> getTestListener() {
        Endpoint endpoint = this.endpoint;
        synchronized (endpoint) {
            return this.testListener;
        }
    }
}

