/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.Authenticator;
import com.couchbase.lite.Collection;
import com.couchbase.lite.CollectionConfiguration;
import com.couchbase.lite.Database;
import com.couchbase.lite.Endpoint;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.ProxyAuthenticator;
import com.couchbase.lite.ReplicatorConfiguration;
import com.couchbase.lite.ReplicatorType;
import com.couchbase.lite.internal.BaseAuthenticator;
import com.couchbase.lite.internal.core.CBLVersion;
import com.couchbase.lite.internal.logging.Log;
import com.couchbase.lite.internal.utils.Preconditions;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BaseImmutableReplicatorConfiguration {
    @NonNull
    private final Map<Collection, CollectionConfiguration> configs;
    @NonNull
    private final Endpoint target;
    @NonNull
    private final ReplicatorType type;
    private final boolean continuous;
    @Nullable
    private final Authenticator authenticator;
    @Nullable
    private final ProxyAuthenticator proxyAuthenticator;
    @Nullable
    private final Map<String, String> headers;
    private final boolean acceptParentCookies;
    @Nullable
    private final X509Certificate pinnedServerCertificate;
    private final int maxAttempts;
    private final int maxAttemptWaitTime;
    private final int heartbeat;
    private final boolean enableAutoPurge;
    @Nullable
    private final Database database;
    private Map<String, Object> options;

    protected BaseImmutableReplicatorConfiguration(@NonNull ReplicatorConfiguration config) {
        Map<Collection, CollectionConfiguration> collectionConfigs = config.getCollectionConfigurations();
        if (collectionConfigs.isEmpty()) {
            throw new IllegalArgumentException("Attempt to configure a replicator with no source collections");
        }
        this.configs = Collections.unmodifiableMap(new HashMap<Collection, CollectionConfiguration>(collectionConfigs));
        this.target = Preconditions.assertNotNull(config.getTarget(), "replication target");
        this.type = Preconditions.assertNotNull(config.getType(), "replicator type");
        this.continuous = config.isContinuous();
        this.authenticator = config.getAuthenticator();
        this.proxyAuthenticator = config.getProxyAuthenticator();
        this.headers = config.getHeaders();
        this.acceptParentCookies = config.isAcceptParentDomainCookies();
        this.pinnedServerCertificate = config.getPinnedServerX509Certificate();
        this.maxAttempts = config.getMaxAttempts();
        this.maxAttemptWaitTime = config.getMaxAttemptWaitTime();
        this.heartbeat = config.getHeartbeat();
        this.enableAutoPurge = config.isAutoPurgeEnabled();
        this.database = Preconditions.assertNotNull(config.getDatabase(), "replications source database");
    }

    @NonNull
    public final Map<Collection, CollectionConfiguration> getCollectionConfigs() {
        return this.configs;
    }

    @Nullable
    public final Database getDatabase() {
        return this.database;
    }

    @NonNull
    public final ReplicatorType getType() {
        return this.type;
    }

    public final boolean isPush() {
        return this.type == ReplicatorType.PUSH_AND_PULL || this.type == ReplicatorType.PUSH;
    }

    public final boolean isPull() {
        return this.type == ReplicatorType.PUSH_AND_PULL || this.type == ReplicatorType.PULL;
    }

    public final boolean isContinuous() {
        return this.continuous;
    }

    @Nullable
    public final Authenticator getAuthenticator() {
        return this.authenticator;
    }

    @Nullable
    public final ProxyAuthenticator getProxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    @Nullable
    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean isAcceptParentCookies() {
        return this.acceptParentCookies;
    }

    @Nullable
    public final X509Certificate getPinnedServerCertificate() {
        return this.pinnedServerCertificate;
    }

    public final int getMaxRetryAttempts() {
        return this.maxAttempts;
    }

    public final int getMaxRetryAttemptWaitTime() {
        return this.maxAttemptWaitTime;
    }

    public final int getHeartbeat() {
        return this.heartbeat;
    }

    public final boolean isAutoPurgeEnabled() {
        return this.enableAutoPurge;
    }

    @NonNull
    public final Endpoint getTarget() {
        return this.target;
    }

    @NonNull
    public Map<String, Object> getConnectionOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (this.authenticator != null) {
            ((BaseAuthenticator)this.authenticator).authenticate(options);
        }
        if (this.proxyAuthenticator != null) {
            ((BaseAuthenticator)this.proxyAuthenticator).authenticate(options);
        }
        if (this.pinnedServerCertificate != null) {
            try {
                options.put("pinnedCert", this.pinnedServerCertificate.getEncoded());
            }
            catch (CertificateEncodingException e) {
                Log.w(LogDomain.NETWORK, "Unable to encode pinned certificate.  Ignoring", e);
            }
        }
        options.put("heartbeat", this.heartbeat > 0 ? this.heartbeat : 300);
        options.put("maxRetryInterval", this.maxAttemptWaitTime > 0 ? this.maxAttemptWaitTime : 300);
        options.put("maxRetries", (this.maxAttempts > 0 ? this.maxAttempts : (this.continuous ? Integer.MAX_VALUE : 10)) - 1);
        options.put("acceptParentDomainCookies", this.acceptParentCookies);
        options.put("autoPurge", this.enableAutoPurge);
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        if (this.headers != null) {
            String cookies = this.headers.remove("Cookies");
            if (cookies != null) {
                Object curCookies = options.get("cookies");
                if (curCookies instanceof String) {
                    cookies = cookies + "; " + curCookies;
                }
                options.put("cookies", cookies);
            }
            httpHeaders.putAll(this.headers);
        }
        httpHeaders.put("User-Agent", CBLVersion.getUserAgent());
        options.put("headers", httpHeaders);
        this.options = options;
        return this.options;
    }
}

