/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.couchbase.lite.Collection;
import com.couchbase.lite.CollectionConfiguration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BaseReplicatorConfiguration {
    @NonNull
    private final Map<Collection, CollectionConfiguration> internalCollectionConfigurations;
    @NonNull
    protected final Map<Collection, CollectionConfiguration> collectionConfigurations;

    protected BaseReplicatorConfiguration(@Nullable Map<Collection, CollectionConfiguration> configs) {
        this.internalCollectionConfigurations = configs != null ? configs : new HashMap();
        this.collectionConfigurations = Collections.unmodifiableMap(this.internalCollectionConfigurations);
    }

    protected void addCollectionInternal(@Nullable Collection coll, @Nullable CollectionConfiguration config) {
        if (coll != null) {
            this.internalCollectionConfigurations.put(coll, config);
        }
    }

    protected void removeCollectionInternal(@Nullable Collection coll) {
        if (coll != null) {
            this.internalCollectionConfigurations.remove(coll);
        }
    }

    @NonNull
    protected Map<Collection, CollectionConfiguration> getCollectionConfigurations() {
        return this.collectionConfigurations;
    }
}

